#include "mbed.h"
#include "rtos.h"
#include "wave_player.h"
#include "SDFileSystem.h"
#include "button.h"
#include "buttonArray.h"
#include <string>
#include <iostream>
#include "emic2.h"

using namespace std;

// DEFINE I/O
PwmOut myservo(p21);
DigitalIn pb1 (p20);
PwmOut myservo2(p22);
DigitalIn pb2 (p19);
PwmOut myservo3(p23);
DigitalIn pb3 (p18);
PwmOut myservo4(p24);
DigitalIn pb4 (p17);
PwmOut myservo5(p25);
DigitalIn pb5 (p16);
PwmOut myservo6(p26);
DigitalIn pb6 (p15);

//DigitalOut led1(LED1);
//DigitalOut led3(LED3);
//DigitalOut led4(LED4);

DigitalIn linpot(p9);
//Serial pc(USBTX, USBRX);
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
//AnalogOut DACout(p26);
//wave_player waver(&DACout);
//button button1(myservo, pb1, linpot);
button button1(myservo, pb1, 1);
button button2(myservo2, pb2, 2);
button button3(myservo3, pb3, 3);
button button4(myservo4, pb4, 4);
button button5(myservo5, pb5, 5);
button button6(myservo6, pb6, 6);

buttonArray buttonarr(button1, button2, button3, button4, button5, button6);

emic2 myTTS(p28, p27); //serial RX,TX pins to emic

// INITIALIZE VARIABLES
// add mode, reset buttons
int start = 0;
int submit = 0;
// Buttons begins in up state
int state = 0;
int state2 = 0;
int state3 = 0;
int state4 = 0;
int state5 = 0;
int state6 = 0;
int count = 0;

// THREADS

void button_thread()
{
    while(true) {
        state = button1.updateState();
        //led4 = button1.getLp();
        Thread::wait(100); // wait till thread is done
    }
}

void button2_thread()
{
    while(true) {
        state2 = button2.updateState();
        Thread::wait(100); // wait till thread is done
    }
}

// thread for the custom button
void button3_thread()
{
    while(true) {
        state3 = button3.updateState();
        Thread::wait(100); // wait till thread is done
    }
}

// thread for the custom button
void button4_thread()
{
    while(true) {
        state4 = button4.updateState();
        Thread::wait(100); // wait till thread is done
    }
}

// thread for the custom button
void button5_thread()
{
    while(true) {
        state5 = button5.updateState();
        Thread::wait(100); // wait till thread is done
    }
}

// thread for the custom button
void button6_thread()
{
    while(true) {
        state6 = button6.updateState();
        Thread::wait(100); // wait till thread is done
    }
}

void submit_thread()
{
    Thread::wait(500); // wait till thread is done
}

void start_thread()
{
    // read pb_start
    // if 1
    start = 1;
    //pc.printf("start %d ", start);
    // else 0
    Thread::wait(500); // wait till thread is done
}


int main()
{

    
    // SETUP
    // pull up the pushbutton to prevent bouncing
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    pb4.mode(PullUp);
    pb5.mode(PullUp);
    pb6.mode(PullUp);
    wait(.001);

    // servos begin at 30 degrees
    // replace with a button setup function
    //buttonarr.setup();

    //led1 = 1;
    //led2 = 1;
    Thread t1(button_thread);
    //Thread t2(button2_thread);
    Thread t3(button3_thread);
    Thread t4(button4_thread);
    Thread t5(button5_thread);
    //Thread t6(button6_thread);
    t1.start(button_thread);
    //t2.start(button2_thread);
    t3.start(button3_thread);
    t4.start(button4_thread);
    t5.start(button5_thread);
    //t6.start(button6_thread);

    // PARSE INPUT FILE FOR LETTERS AND WORDS
    char delimiter = ',';
    // TODO: fix the letters
    string letter[2];
    string word[2];
    char check;
    string temp;
    string tempword = "";
    int counter = 0;
    FILE *fp = fopen("/sd/plan.txt", "r"); //create file
    if(fp == NULL) {
        //pc.printf("Could not open file for write\n");
    }
    check = fgetc(fp); //grabs a char from file
    while(check != '\n') {  //while not at the end of line for letters
        if((check == delimiter) && (temp.length() == 1)) {  //at a comma and have a letter stored
            letter[counter] = temp; //write letter
            //pc.printf("Letter: %s \n", letter[counter]);
            counter = counter + 1;  //increment counter
        } else {
            temp = check;   //store letter
        }
        check = fgetc(fp);  //grabs next char
    }
    counter = 0;    //reset counter
    check = fgetc(fp);  //grabs next char
    while(!feof(fp)) {  //while not at the end of line for words
        if(check == delimiter) {  //when at the comma at the end of a word
            word[counter] = tempword;   //write word
            //pc.printf("Word: %s \n", word[counter]);
            tempword = "";
            counter = counter + 1;  //increment counter
        } else {
            tempword = tempword + check;    //concatenate letters to build word
        }
        check = fgetc(fp);  //grabs next char
    }
    fclose(fp); //close file

    // start threads for reset, mode, start
    //Thread t1(start_thread);
    //pc.printf("start thread");
    //Thread t2(submit_thread);
    // setup SDcard and Speaker

    // when started
    //while (start == 0){}
    //Thread t3(button_thread);
    //pc.printf("button thread");
    //Thread t4(button2_thread);
    //pc.printf("button2 thread");

    //Thread t3(submit_thread);

    // when submitted
    //while (submit == 0) {}

    // start button threads and submit thread
    // if submit close button threads and submit thread
    // check result
    // play results on speaker
    // save results

    char currletter;
    int lettersize = sizeof(letter)/sizeof(letter[0]);
    for (int i = 0; i < lettersize; i++) {
        currletter = letter[i][0];
        //pc.printf("currletter %c \n", currletter);
        //pc.printf("braille %s \n", buttonarr.getBraille(currletter));
    }

    /*int* pinsup = buttonarr.pinsUp('M');
    int currpress;
    // get what pins to press
    for (int i = 1; i <= pinsup[0]; i++) {
        // speaker stuff
        currpress = pinsup[i];
    }*/

    /*int* wrongpins = buttonarr.wrongPins('M', 'O');
    int currwrong;
    // get what pins are wrong
    for (int i = 1; i <= wrongpins[0]; i++) {
        // speaker stuff
        currwrong = wrongpins[i];
    }*/

    //TEXT-TO-SPEECH LOGIC
    myTTS.volume(18); //max volume
    string repeat = "Please try again.";

    myTTS.speakf("SWelcome to Bat, the Braille Assistive Teacher. This device will help you learn how to write and type braille.\r");  // Send the desired string to convert to speech
    myTTS.ready(); //ready waits for speech to finish from last command with a ":" response
    for(int i = 0; i < lettersize; i++) {  //iterate through the letter array
        char currletter = letter[i][0];
        //pc.printf("letter: %c \n", currletter);
        int* pinsup = buttonarr.pinsUp(currletter);
        int currpress;
        int numpinsups = pinsup[0];  // size of array is first element of pinsup
        //string presspin;
        string presspin = "STo write the letter ";
        presspin = presspin + letter[i];
        presspin = presspin + ", press pins";

        for (int j = 1; j < numpinsups; j++) {  // get what pins to press
            currpress = pinsup[j];
            switch (currpress) {
                case 1:
                    presspin = presspin + " 1,";
                    break;
                case 2:
                    presspin = presspin + " 2,";
                    break;
                case 3:
                    presspin = presspin + " 3,";
                    break;
                case 4:
                    presspin = presspin + " 4,";
                    break;
                case 5:
                    presspin = presspin + " 5,";
                    break;
                case 6:
                    presspin = presspin + " 6,";
                    break;
            }
        }
        myTTS.speakf("%s\r",presspin);
        myTTS.ready(); //ready waits for speech to finish from last command with a ":" response
        wait(1);
        
        char userinput = buttonarr.checkVal();
        // get input
        //pc.printf("Your input was: %c", userinput);
        
        // check result
        int* wrongpins = buttonarr.wrongPins(userinput, currletter);
        
        //pc.printf("wrongpins are: %d", wrongpins[0]);
    }
    //myTTS.speakf("STo write the letter %s, press pins %D\r",letter[i]);
    //myTTS.ready(); //ready waits for speech to finish from last command with a ":" response


    //pc.printf("current braille %c \n", buttonarr.checkVal());
    //pc.printf("%c\n", buttonarr.releaseButtons());

    // MAIN THREAD
    while(true) {

        // read linear potentiometer
        //led4 = linpot;

        Thread::wait(500); // wait till thread is done
    }
}