#include "mbed.h"
#include "rtos.h"
#include "SDFileSystem.h"
#include "button.h"
#include "buttonArray.h"
#include <string>
#include <iostream>
#include "emic2.h"

using namespace std;

// DEFINE I/O
PwmOut myservo(p21);
DigitalIn pb1 (p20);
PwmOut myservo2(p22);
DigitalIn pb2 (p19);
PwmOut myservo3(p23);
DigitalIn pb3 (p18);
PwmOut myservo4(p24);
DigitalIn pb4 (p17);
PwmOut myservo5(p25);
DigitalIn pb5 (p16);
PwmOut myservo6(p26);
DigitalIn pb6 (p15);

Serial pc(USBTX, USBRX);
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
button button1(myservo, pb1, 1);
button button2(myservo2, pb2, 2);
button button3(myservo3, pb3, 3);
button button4(myservo4, pb4, 4);
button button5(myservo5, pb5, 5);
button button6(myservo6, pb6, 6);

buttonArray buttonarr(button1, button2, button3, button4, button5, button6);

emic2 myTTS(p28, p27); //serial RX,TX pins to emic

// INITIALIZE VARIABLES
// add mode, reset buttons
int start = 0;
int submit = 0;
// Buttons begins in up state
int state = 0;
int state2 = 0;
int state3 = 0;
int state4 = 0;
int state5 = 0;
int state6 = 0;
int count = 0;

// THREADS
void button_thread()
{
    while(true) {
        state = button1.updateState();
        state6 = button6.updateState();
        Thread::wait(100); // wait till thread is done
    }
}

void button2_thread()
{
    while(true) {
        state2 = button2.updateState();
        Thread::wait(200); // wait till thread is done
    }
}

void button3_thread()
{
    while(true) {
        state3 = button3.updateState();
        Thread::wait(200); // wait till thread is done
    }
}

void button4_thread()
{
    while(true) {
        state4 = button4.updateState();
        Thread::wait(200); // wait till thread is done
    }
}

void button5_thread()
{
    while(true) {
        state5 = button5.updateState();
        Thread::wait(200); // wait till thread is done
    }
}

void button6_thread()
{
    while(true) {
        state6 = button6.updateState();
        Thread::wait(200); // wait till thread is done
    }
}

void submit_thread()
{
    Thread::wait(500); // wait till thread is done
}

void start_thread()
{
    start = 1;
    Thread::wait(500); // wait till thread is done
}

int main()
{
    // SETUP; pull up the pushbutton to prevent bouncing
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    pb4.mode(PullUp);
    pb5.mode(PullUp);
    pb6.mode(PullUp);
    wait(.001);

    // servo setup up function; servos begin at 30 degrees
    buttonarr.setup();

    // PARSE INPUT FILE FOR LETTERS AND WORDS
    char delimiter = ',';
    string letter[2];
    string word[2];
    char check;
    string temp;
    string tempword = "";
    int counter = 0;
    FILE *fp = fopen("/sd/plan.txt", "r"); //create file
    check = fgetc(fp); //grabs a char from file
    while(check != '\n') {  //while not at the end of line for letters
        if((check == delimiter) && (temp.length() == 1)) {  //at a comma and have a letter stored
            letter[counter] = temp; //write letter
            counter = counter + 1;  //increment counter
        } else {
            temp = check;   //store letter
        }
        check = fgetc(fp);  //grabs next char
    }
    counter = 0;    //reset counter
    check = fgetc(fp);  //grabs next char
    while(!feof(fp)) {  //while not at the end of line for words
        if(check == delimiter) {  //when at the comma at the end of a word
            word[counter] = tempword;   //write word
            tempword = "";
            counter = counter + 1;  //increment counter
        } else {
            tempword = tempword + check;    //concatenate letters to build word
        }
        check = fgetc(fp);  //grabs next char
    }
    fclose(fp); //close file
    
    //INITIALIZE THREADS
    Thread t1(button_thread);
    Thread t2(button2_thread);
    Thread t3(button3_thread);
    Thread t4(button4_thread);
    Thread t5(button5_thread);
    t1.start(button_thread);
    t2.start(button2_thread);
    t3.start(button3_thread);
    t4.start(button4_thread);
    t5.start(button5_thread);

    char currletter;
    int lettersize = sizeof(letter)/sizeof(letter[0]);
    int type = 0;

    //TEXT-TO-SPEECH LOGIC
    myTTS.volume(1); //max volume is 18
    myTTS.voice(2);

    char* braille;
    char userinput;

    // INITIAL RESET
    if (type == 0) {
        int reset = 1;
        myTTS.speakf("SWelcome to Bat, the Braille Assistive Teacher. This device will help you learn how to write and type braille. Please setup the device by pressing down all the buttons.\r");
        myTTS.ready(); //ready waits for speech to finish from last command with a ":" response
        while(reset == 1) {
            wait(3);
            sprintf(braille, "%d%d%d%d%d%d", button1.getPress(), button2.getPress(),
                    button3.getPress(), button4.getPress(), button5.getPress(), button6.getPress());
            userinput = buttonarr.checkVal(braille);
            if(userinput == 'Z') {
                reset = 0;
            } else {
                myTTS.speakf("SSetup failed. Please try again.\r");
                myTTS.ready(); //ready waits for speech to finish from last command with a ":" response
            }
        }
    }

    for(int i = 0; i < lettersize; i++) {  //iterate through the letter array
        char currletter = letter[i][0];
        int* pinsup = buttonarr.pinsUp(currletter);
        int currpress;
        int numpinsups = pinsup[0];  // size of array is first element of pinsup
        string presspin = "STo write the letter ";
        presspin = presspin + letter[i];
        presspin = presspin + ", press buttons";

        for (int j = 1; j < numpinsups; j++) {  // get what pins to press
            currpress = pinsup[j];
            switch (currpress) {
                case 1:
                    presspin = presspin + " 1,";
                    break;
                case 2:
                    presspin = presspin + " 2,";
                    break;
                case 3:
                    presspin = presspin + " 3,";
                    break;
                case 4:
                    presspin = presspin + " 4,";
                    break;
                case 5:
                    presspin = presspin + " 5,";
                    break;
                case 6:
                    presspin = presspin + " 6,";
                    break;
            }
        }
        myTTS.speakf("%s\r",presspin);
        myTTS.ready(); //ready waits for speech to finish from last command with a ":" response
        wait(2);

        char* braille;
        char userinput;
        char* oldbraille;
        if (type == 0) {
            sprintf(braille, "%d%d%d%d%d%d", button1.getPress(), button2.getPress(),
                    button3.getPress(), button4.getPress(), button5.getPress(), button6.getPress());
            userinput = buttonarr.checkVal(braille);
        } else {
            // TYPE MODE
            sprintf(braille, "%d%d%d%d%d%d", !button1.getPress(), !button2.getPress(),
                    !button3.getPress(), !button4.getPress(), !button5.getPress(), !button6.getPress());
            userinput = buttonarr.checkVal(braille);
            oldbraille = braille;
        }

        int currwrong;
        string wrongpin;
        // check result
        pc.printf("\n %c %c", userinput, currletter);
        int* wrongpins = buttonarr.wrongPins(braille, currletter);
        int test = 1;
        while(test == 1) {
            wrongpin = "SYour answer is incorrect. Buttons";
            for (int j = 1; j < wrongpins[0]; j++) {  // get what pins are wrong
                currwrong = wrongpins[j];
                switch (currwrong) {
                    case 1:
                        wrongpin = wrongpin + " 1,";
                        break;
                    case 2:
                        wrongpin = wrongpin + " 2,";
                        break;
                    case 3:
                        wrongpin = wrongpin + " 3,";
                        break;
                    case 4:
                        wrongpin = wrongpin + " 4,";
                        break;
                    case 5:
                        wrongpin = wrongpin + " 5,";
                        break;
                    case 6:
                        wrongpin = wrongpin + " 6,";
                        break;
                }
            }
            if (wrongpins[0] > 1) {
                wrongpin = wrongpin + " are wrong. Please try again.";
                myTTS.speakf("%s\r",wrongpin);
                myTTS.ready(); //ready waits for speech to finish from last command with a ":" response
                wait(2);
                //UPDATE THE PINS THAT ARE WRONG BY CHECKING AGAIN BELOW
                sprintf(braille, "%d%d%d%d%d%d", button1.getPress(), button2.getPress(),
                button3.getPress(), button4.getPress(), button5.getPress(), button6.getPress());
                userinput = buttonarr.checkVal(braille);
                
                // check result
                wrongpins = buttonarr.wrongPins(braille, currletter);
            } else {
                test = 0;
                myTTS.speakf("SGood job!\r");
                myTTS.ready(); //ready waits for speech to finish from last command with a ":" response
            }
        }

        if (type == 0) {
            int reset = 1;
            myTTS.speakf("SNow reset by pressing down all the buttons.\r");
            myTTS.ready(); //ready waits for speech to finish from last command with a ":" response
            while(reset == 1) {
                char* braille;
                sprintf(braille, "%d%d%d%d%d%d", button1.getPress(), button2.getPress(),
                        button3.getPress(), button4.getPress(), button5.getPress(), button6.getPress());
                userinput = buttonarr.checkVal(braille);
                if(userinput == 'Z') {
                    reset = 0;
                } else {
                    wait(2);
                    myTTS.speakf("SPlease try again.\r");
                    myTTS.ready(); //ready waits for speech to finish from last command with a ":" response
                }
            }
        }
    }

// MAIN THREAD
    while(true) {

        Thread::wait(500); // wait till thread is done
    }
}