#include "mbed.h"

#ifndef BUTTON_H
#define BUTTON_H

// This is a button class for our custom button
class button {

// pins connected to the button
private:
    PwmOut servo;
    DigitalIn pb;
    int state; // where is the button (0 - 4)
    int press; // is the button up or down
    int id;    // this is the ID, each button should have a unique id

public:
    // constructors
    button(); // Default
    button(PwmOut servo, DigitalIn pb, int id);

    // functions
    PwmOut getServoPin(); // get the servo pin
    void setState(int);     // set what state the button is in - up or down
    void setPress(int);     // set the button press
    void moveServoIn();   // move servo into the slot
    void moveServoOut();  // move servo out of the slot
    int getID();
    int updateState();
    int getState();
    int getPress();
    int getLp();
    void setup();
};

#endif