#include "mbed.h"
#include "button.h"
#include "emic2.h"

//emic2 myTTS(p28, p27); //serial RX,TX pins to emic
DigitalOut led4(LED4);
DigitalOut led3(LED3);
DigitalOut led2(LED2);

// button constructor
button::button(PwmOut servo, DigitalIn pb, int id)
    : servo(servo), pb(pb), state(0), press(0), id(id) {}

// FUNCTIONS
// get servo pin
PwmOut button::getServoPin()
{
    return servo;
}

// set button state
void button::setState(int mystate)
{
    state = mystate;
}

void button::setPress(int mypress)
{
    press = mypress;
}

// get current state of the button
int button::getState()
{
    return state;
}

int button::getID()
{
    return id;
}


int button::getPress()
{
    return press;
}

// get current state of the button
int button::getLp()
{
    return 0;
}

// move servo into the slot
void button::moveServoIn()
{
    // rotate 90 degrees one way
    for(int i=4; i<=7; i++) {
        servo = i/100.0;
        wait(0.01);
    }
    switch (id) {
        case 1:
            led2 = 0;
            led3 = 0;
            led4 = 1;
            break;
        case 2:
            led2 = 0;
            led3 = 1;
            led4 = 0;
            break;
        case 3:
            led2 = 0;
            led3 = 1;
            led4 = 1;
            break;
        case 4:
            led2 = 1;
            led3 = 0;
            led4 = 0;
            break;
        case 5:
            led2 = 1;
            led3 = 0;
            led4 = 1;
            break;
        case 6:
            led2 = 1;
            led3 = 1;
            led4 = 0;
            break;
    }
}

// move servo out of the slot
void button::moveServoOut()
{
    for(int i=7; i>4; i--) {
        servo = i/100.0;
        wait(0.01);
    }
    led2 = 0;
    led3 = 0;
    led4 = 0;
}

int button::updateState()
{
    // state 0 - button is up, pb = 0
    if (pb == 0 && state == 3) {
        // nothing happens here, servo is still
        state = 0;
    }
    // state 1 - button is moving down, pb = 1
    if (pb == 1 && state == 0) {
        moveServoIn();
        state = 1;
        press = 1;
    }
    // state 2 - button is down, pb = 0
    if (pb == 0 && state == 1) {
        // nothing happens here, servo is still
        state = 2;
    }
    // state 3 - button is moving up, pb = 1
    if (pb == 1 && state == 2) {
        moveServoOut();
        state = 3;
        press = 0;
    }
    // state 4 - handle debouncing while button is down
    return state;
}

void button::setup() {
    for(int i=0; i<=4; i++) {
        servo = i/100.0;
        wait(0.01);
    }
}
