// Demonstrates the use of Bluetooth with each of the systems functionalities:
// Cup dispenser, dispensing drink 1, dispensing drink 2, and conveyor belt.
// This code:
// - dispenses a cup when button 1 is pressed
// - dispenses drink 1 when button 2 is pressed
// - dispenses drink 2 when button 3 is pressed
// - moves converyor belt for 4 seconds when button 4 is pressed

#include "mbed.h"
#include "Motor.h"
#include "Servo.h"

Servo poker(p22);
DigitalIn stby(p25);
Motor tread(p24, p12, p11);         // pwm, fwd, rev (H-bridge)
Motor pump(p26, p13, p14);          // pwm, fwd, rev (H-bridge)
DigitalOut tread2(p21);             // MOSFET
BusOut myled(LED1,LED2,LED3,LED4);  // check for which button is pressed
Serial blue(p28,p27);               // Bluetooth
float cupos = 0;
void cupdispense();
void drink1();
void drink2();
void treads(float time); 

int main()
{
    stby.mode(PullUp);
    poker = cupos;
    char bnum=0;
    char bhit=0;
    while(1) {
        if (cupos >=1){
            cupos = 0;
            poker = cupos;
        }
        if (blue.getc()=='!') {
            if (blue.getc()=='B') { //button data packet
                bnum = blue.getc(); //button number
                bhit = blue.getc(); //1=hit, 0=release
                if (blue.getc()==char(~('!' + 'B' + bnum + bhit))) { //checksum OK?
                    myled = bnum - '0'; //current button number will appear on LEDs
                    switch (bnum) {
                        //case '1': //number button 1
//                            if (bhit=='1') {
//                                //add hit code here
//                                cupdispense();
//                                
//                            } else {
//                                //add release code here
//                            }
//                            break;
                        case '2': //number button 2
                            if (bhit=='1') {
                                //add hit code here
                                drink1();
                            } else {
                                //add release code here
                            }
                            break;
                        case '3': //number button 3
                            if (bhit=='1') {
                                //add hit code here
                                drink2();
                            } else {
                                //add release code here
                            }
                            break;
                        case '4': //number button 4
                            if (bhit=='1') {
                                //add hit code here
                                treads(4);
                            } else {
                                //add release code here
                            }
                            break;
                        
                        default:
                            break;
                    }
                }
            }
        }
    }
}

void cupdispense(){
    //cupos += .3;
//    poker = cupos;
//    wait(0.1);
for(float p=0; p<1; p += 0.05) {
        poker = p;
        wait(1);
    }
    poker = 0;
}

void drink1(){
    pump.speed(1);
    wait(2);
    pump.speed(0);

}

void drink2(){
    pump.speed(-1);
    wait(2);
    pump.speed(0);
}

void treads(float time) {
    tread.speed(1);
    tread2 = 1;
    wait(time);
    tread.speed(0);
    tread2 = 0;
}

