/*
 * SerialServer.h
 * Copyright (c) 2017, ZHAW
 * All rights reserved.
 *
 *  Created on: 05.06.2017
 *      Author: Marcel Honegger
 */

#ifndef SERIAL_COM_H_
#define SERIAL_COM_H_

#include <cstdlib>
#include <string>
#include <vector>
#include <mbed.h>
#include "Signal.h"

using namespace std;



/**
 * This class implements a communication server using a serial interface.
 */
class SerialCom {
    
    public:
        
                    SerialCom(RawSerial& serial);
        virtual     ~SerialCom();
        
    private:
        
        static const uint32_t   STACK_SIZE = 2048 ;      // stack size of thread, given in [bytes]
        static const float      PERIOD;                 // the period of the timer interrupt, given in [s]
        static const char       DELIM;
        
        RawSerial&      serial;
        string          input;
        string          output;
        vector<string>  tokens;
        Signal          signal;
        Thread          thread;
        Ticker          ticker;
        bool            sendData;
        int             runCount;

        void            sendSignal();
        void            run();
        void            splitString();
};

#endif /* SERIAL_COM_H_ */
