/*
 * Main.cpp
 * Copyright (c) 2017, ZHAW
 * All rights reserved.
 *
 *  Created on: 06.10.2017
 *      Author: Marcel Honegger
 */
#include "SerialCom.h"
#include <cstdlib>
#include <mbed.h>



    

using namespace std;

class Main {
    
    public:
        
                    Main();
        virtual     ~Main();
        
    private:
        
        static const uint32_t   STACK_SIZE = 8192;  // stack size of thread, given in [bytes]
        
        Thread      thread;
        void        run();
};

Main::Main() : thread(osPriorityNormal, STACK_SIZE) {
    
    thread.start(callback(this, &Main::run));
}

Main::~Main() {}

void Main::run() {
    
    // create miscellaneous periphery objects
    
    DigitalOut led(LED1);
    DigitalIn button(USER_BUTTON);
    
    // create serial server object

    
    
    RawSerial serial(PA_0, PA_1);
    serial.baud(38400);
    serial.format(8, SerialBase::None, 1);
    
    DigitalOut reset(PB_12);
    DigitalOut modes1(PB_0);
    
    modes1 = 0;
    
    reset = 1; Thread::wait(100);
    reset = 0; Thread::wait(100);
    reset = 1; Thread::wait(100);
    
    SerialCom serialCom(serial);
    
    // enter main loop
    
    while (true) {
        
        led = !led;
        /*
        if (//stateMachine.getState() == StateMachine::STATE_MANUAL) {
            Thread::wait(100);
        } else if (//stateMachine.getState() == StateMachine::STATE_AUTOMATIC) {
            Thread::wait(200);
        } else {
            Thread::wait(500);
        }
        */
    }
}

/**
 * This is the main program of the ROME2RevG firmware.
 */
int32_t main() {
    
   /* Serial pc(USBTX, USBRX); // tx, rx
    pc.baud(9600);
    pc.printf("was here\r\n");*/
    
    Main main;
    
    Thread::wait(osWaitForever);
}
