#include "mbed.h"
#include "math.h"
//------------------------------------------
#define PI 3.1415927f
//------------------------------------------
#include "EncoderCounter.h"
#include "DiffCounter.h"
#include "IIR_filter.h"
#include "LinearCharacteristics.h"

PwmOut pwm1(PA_5);

float inc2rad = 2.0f*3.1415927f/(4.0f*6400.0);

int main()
{

    EncoderCounter counter1(PB_6, PB_7);
    DiffCounter diffc(0.9f,0.05f);


    pwm1.period(0.00005f);

    while(1) {
        short inc = counter1.read();
        float velocity = diffc(inc);
        printf("angle = %.2f velocity = %.2f\r\n",inc*inc2rad,velocity);

        pwm1.write(0.5f);
        wait(0.05f);
    }
}


