#include "mbed.h"
#include "RFD77402.h"


I2C i2c(PB_9, PB_8);

uint16_t distance;
uint16_t confidence_value;
uint8_t valid_pixles;

uint8_t error_code;

int main()
{

    printf("i2c created \n\r");
    RFD77402 sensor(&i2c);
    printf("sensor created \n\r");
    if (sensor.init()) printf ("init success \n\n\r");
    else printf("init fail \n\r");

    for (uint8_t x = 0 ; x < 100 ; x++) {
        error_code = sensor.takeMeasurement();
        if (error_code) 
        {
            printf("error %d\n\r", error_code);
        } 
        else 
        {
            distance = sensor.getDistance();
            confidence_value = sensor.getConfidenceValue();
            valid_pixles = sensor.getValidPixels();

            printf("distance = %d mm\t confidence = %d\t valid pixels: %d\n\r", distance, confidence_value, valid_pixles);
        }
        wait(0.5);
    }
}
