#include "mbed.h"
#include "EncoderCounter.h"
#include "IMU.h"
#include "Controller.h"

// create miscellaneous periphery objects
DigitalOut led1(PB_13);
DigitalOut led2(PC_8);
DigitalOut led3(PC_9);
DigitalOut led4(PC_0);
DigitalOut led5(PC_1);
DigitalOut led6(PH_1);
DigitalOut led7(PC_2);
DigitalOut led8(PC_3);
DigitalOut led9(PB_0);

DigitalIn user_button(USER_BUTTON);
//DigitalIn reset_button(NRST);

// create IMU comunication objects
SPI spi(PC_12, PC_11, PC_10); // mosi, miso, sclk
DigitalOut csAG(PA_15);
DigitalOut csM(PD_2);

// create motor control objects
DigitalOut enable1(PB_1);
DigitalOut enable2(PB_2);
DigitalOut enable3(PB_3);

PwmOut pwm1(PA_8);
PwmOut pwm2(PA_9);
PwmOut pwm3(PA_10);

AnalogIn M1_AOUT1(PB_4);
AnalogIn M1_AOUT2(PB_5);
DigitalIn M1_DIO3(PB_12);
DigitalIn M1_DIO4(PC_7);

AnalogIn M2_AOUT1(PB_14);
AnalogIn M2_AOUT2(PB_15);
DigitalIn M2_DIO3(PA_4);
DigitalIn M2_DIO4(PA_5);

AnalogIn M3_AOUT1(PA_7);
AnalogIn M3_AOUT2(PA_11);
DigitalIn M3_DIO3(PA_12);
DigitalIn M3_DIO4(PC_4);

// crete Encoder read objects
EncoderCounter counter1(PA_6, PC_7);
EncoderCounter counter2(PB_6, PB_7);
EncoderCounter counter3(PA_1, PA_0);

// create distance sensor objects

// create robot controller objects

// create serial comunication objects, bluetooth/wifi

// enter main loop
int main()
{
// instance objects

    //IMU
    IMU imu(spi, csAG, csM);
    //controller
    Controller controller(pwm1,pwm2,pwm3,counter1,counter2,counter3,imu);
    //stateMachine

    while (true) {

        //printf tests

        led1 = !led1;
        wait(0.5);
    }
}
