/*
 * Controller.cpp
 * Copyright (c) 2018, ZHAW
 * All rights reserved.
 *
 *  Created on: 27.03.2018
 *      Author: BaBoRo Development Team
 */

#ifndef CONTROLLER_H_
#define CONTROLLER_H_

#include <stdint.h>
#include "mbed.h"
#include "EncoderCounter.h"
#include "IMU.h"
#include "LowpassFilter.h"

/**
 * controller class
 */
class Controller {
    
    public:
        
        //static const float      TRANSLATIONAL_PROFILE_VELOCITY;
        //static const float      ROTATIONAL_PROFILE_VELOCITY;
        static const float        ALPHA;
        static const float        RB;
        static const float        RW;
        static const float        PI;
        static const float        SQRT_3;
        static const float        LOWPASS_FILTER_FREQUENCY;
        static const float        COUNTS_PER_TURN;
        static const float        KI;
        static const float        MIN_DUTY_CYCLE;
        static const float        MAX_DUTY_CYCLE;
        
                    Controller(PwmOut& pwm0, PwmOut& pwm1, PwmOut& pwm2, EncoderCounter& counter1, EncoderCounter& counter2, EncoderCounter& counter3, IMU& imu);
        virtual     ~Controller();
        void        setGammaX(float gammaX);
        void        setGammaY(float gammaY);
        void        setGammaZ(float gammaZ);
        void        setPhiX(float phiX);
        void        setPhiY(float phiY);
        void        setX(float x);
        void        setY(float y);
        
        float       getPhiX();
        float       getPhiY();
        float       getX();
        float       getY();

        
    private:
        
        static const uint32_t   STACK_SIZE = 4096;  // stack size of thread, given in [bytes]
        static const float      PERIOD;             // the period of the timer interrupt, given in [s]
        
        PwmOut&             pwm0;
        PwmOut&             pwm1;
        PwmOut&             pwm2;
        
        EncoderCounter&     counter1;
        EncoderCounter&     counter2;
        EncoderCounter&     counter3;
        
        float               gammaX;
        float               gammaY;
        float               gammaZ;
        float               phiX;
        float               phiY;
        float               x;
        float               y;
        
        float               d_gammaX;
        float               d_gammaY;
        float               d_gammaZ;
        float               d_phiX;
        float               d_phiY;
        
        LowpassFilter       speedFilter1;
        LowpassFilter       speedFilter2;
        LowpassFilter       speedFilter3;
        
        float               previousValueCounter1;
        float               previousValueCounter2;
        float               previousValueCounter3;
        float               actualSpeed1;
        float               actualSpeed2;
        float               actualSpeed3;
        
        IMU&                imu;
        //Signal              signal;
        Thread              thread;
        //Ticker              ticker;
        
        //void        sendSignal();
        void        run();
};

#endif /* CONTROLLER_H_ */
