#include "mbed.h"
#include "eeprom.h"

EEPROM memory(I2C_SDA,I2C_SCL,0);
DigitalIn mode(A1);
BusOut led(D9,D10,D11,D12,D13,A3,PB_14);
BusIn logic(D2,D3,D4,D5,D6,D7,PB_2);
DigitalIn sw(A2);

int main() {
    int countWrite = 0;
    int countRead = 0;
    int8_t data = 0;
    while(1)
    {
        if(mode == 1)
        {
            while(1)
            {
                if (sw == 1){
                    memory.write(countWrite,(int8_t)logic);
                    countWrite ++;
                    wait_ms(100);
                }
                if (mode == 0){
                    break;
                }
            }
        }
        else if(mode == 0)
        {
            while(1)
            {
                if (sw == 1)
                {
                    if (countRead <= countWrite)
                    {
                        countRead ++;
                        memory.read(countRead,data);
                        led = data;
                        wait_ms(100);
                    }
                    else 
                    {
                        countRead = 0 ;
                    }
                }
                if (mode == 1){
                    countWrite = 0;
                    countRead = 0;
                    break;
                }
                wait_ms(5);
            }
        }
    }
}
