#include "mbed.h"
#include "MCP4922.h"

MCP4922 MCP(SPI_MOSI, SPI_SCK,PB_6);  // MOSI, SCLK, CS
/*หลักการคิดคือ จะแบ่งเป็น 4state โดยในแต่ละ state จะเป็นการเพิ่มหรือลดของ ค่า i โดยจะวนลูปเรื่อยๆจนออกจากเงื่อนไขและเปลี่ยน state  */

/**** Main Function  ***/
int main(void)
{
    MCP.frequency(5000000);

    uint16_t i=0; //สร้างตัวแปร(int) 16 bit ชื่อ i ให้มีค่าเท่ากับ 0
    uint8_t state=0; //สร้างตัวแปร(int) 8 bit ชื่อ state ให้มีค่าเท่ากับ 0
    while(1) { //สร้างลูปให้ทำงานเมื่อมีไฟเข้า
        if(state == 0) { //ถ้า state = 0 ให้ทำด้านล่าง
            if(i < 0x0FFE/2) { //ถ้า i น้อยกว่าครึ่งหนึ่งของ 4094 ให้ i เพิ่มขึ้น และแสดงค่าที่จอ scop
                i++;
                MCP.writeA(i); 
            }
            else { //แต่ถ้าไม่ใช่ให้ i เท่ากับครึ่งหนึ่งของ 4094 และให้ state = 1
                i = 0x0FFE/2
                state = 1; 
            }
        }
        else if(state == 1) { //ถ้า state = 1 ให้ทำด้านล่าง
            if(i > 0) { //ถ้า i มากกว่า 0 ให้ i ลดลง และแสดงที่จอ scop
                i--;
                MCP.writeA(i);
            }     
            else { //แต่ถ้าไม่ใช่ให้ i เท่ากับครึ่งหนึ่งของ 4095 และให้ state = 2
                i = 0x0FFF;
                state = 2;
            }                   
        }
        else if(state == 2) { //ถ้า state = 2 ให้ทำด้านล่าง
            if(i > (0x0FFE/2)) { //ถ้า i มากกว่า ครึ่งหนึ่งของ 4094 ให้ i ลดลง และแสดงที่จอ scop
                i--;
                MCP.writeA(i);
            }     
            else { //แต่ถ้าไม่ใช่ให้ i เท่ากับครึ่งหนึ่งของ 4094 และให้ state = 3
                i= 0x0FFE/2;
                state = 3;
            }                   
        }
        else if(state == 3) { //ถ้า state = 3 ให้ทำด้านล่าง
            if(i < 0x0FFE) { //ถ้า i น้อยกว่า 4094 ให้ i เพิ่มขึ้น และแสดงค่าที่จอ scop
                i++; 
                MCP.writeA(i);
            }     
            else { //แต่ถ้าไม่ใช่ให้ i เท่ากับ 0 และให้ state เท่ากับ 0
                i= 0;
                state = 0;
            }                   
        }                                              
        wait_us(15); //รอ 15 ไมโครวินาที เพื่อไปต่อ
    }
}