
#include "mbed.h"
#include "MCP4922.h"

MCP4922 MCP(SPI_MOSI, SPI_SCK,PB_6);  // MOSI, SCLK, CS


/**** Main Function  ***/
int main(void)
{
    MCP.frequency(1000000);

    uint16_t i=0;
    uint8_t state=0;
    while(1) {
        if (state == 0){
            if(i < 0x0FFE/2) {
                MCP.writeA(i);
                i++;
            } else {
                i=0x0FFE/2;
                state = 1;
            }
        }
        else if (state == 1){
            if(i <= 0x0FFE/2) {
                MCP.writeA(i);
                i--;
            } else {
                i= 0x0FFF ;
                MCP.writeA(i);
                i = 0;
                state = 2;
            }
        }
        else if (state == 2){
            if(i < 0x0FFF/2) {
                MCP.writeA(~i);
                i++;
            } else {
                i=0x0FFF/2;
                state = 3;
            }
        }
        else if (state == 3){
            if(i < 0x0FFF) {
                MCP.writeA(i);
                i++;
            } else {
                i=0;
                state = 0;
            }
        }
        wait_us(1);
    }
}