#include "mbed.h"
#include <math.h>

BusOut font(D3,D4,D5,D6);       // แสดงผลที่ seven segment ตัวหน้า 
BusOut back(D7,D15,D9,D10);      // แสดงผลที่ seven segment ตัวหลัง 
BusOut myleds(A0,A1,A2,A3,D11,D12,D13,D14);     // แสดงผลที่หลอดไฟ LED บนบอร์ด NX-100

DigitalIn button(USER_BUTTON);      // กำหนดให้ user_button ที่บอร์ด เป็นตัวรับที่กำหนดการเปลี่ยน mode
DigitalOut point(D2);       // กำหนดให้ จุดทศนิยมบน seven segment
AnalogIn value(A4);         // กำหนดให้ A4 เป็น pin ที่รับค่า v  จากบอร์ด NX-100


int main() {
    float state = 0;        // กำหนด state เป็นตัวเปลี่ยน mode ที่แสดงระหว่างแสดงทางหลอดไฟและทาง seven-segment
    float read;         // กำหนดให้ตัวแปร read เป็นประเภท float เพื่ออ่านข้อมูลจาก analog 
    float b,f,d;        // กำหนดตัวแปรเพื่อช่วยในการทำ seven-segment
    d = 10.0;       // ให้ d=10 เพื่อเป็นตัวเลขมาช่วยคำนวนแยกหลักหน่วยและทศนิยมอันดับ 1
    while(1){
        // Lab 2.3
        printf("state = %f \n", state); // แสดงค่าบน serail monitor
        if(button == 0)     // เมื่อกด button 
        {  // 
            if(state <1){   // ถ้าค่าของ state น้อยกว่า 1 หรือคือ 0
                state++ ;    // ให้ ค่า state += 1 หรือ state = 1
            }
            else{ // ถ้า state มากกว่า 1 หรือเท่ากับ 1
                state = 0;}   // ให ้state = 0 
        }
        // Lab 2.2
        if(state == 1)  // เมื่อ state = 1 ให้ทำ mode ที่แสดงแรงดันผ่านทาง seven-segment
        {
            while(1){   // วนลูปให้ทำเรื่อยๆ
            read = value.read();    // ให้ตัวแปร read คือค่าที่ input เข้ามาเป็น analog 
            read = read * 33;       // นำไปคูณ 33 เพื่อให้เป็นช่วง 0-33 และสามารถนำมาคำนวณได้ง่าย
            b = fmod(read,d);       // ให้ b เท่ากับ เลขในทศนิยมอันดับหนึ่งของแรงดัน โดยการนำค่าที่ได้มา mod 10
            f = read / d;       // ให้ f เท่ากับ เลขในหลักหน่วยของแรงดัน โดยการนำค่าที่ได้มาหาร 10
            printf("%f \n",read);   // แสดงค่าread บน serial monitor
            font = f;       // ให้ Busout font หรือตัวหน้า เท่ากับหลักหน่วย
            back = b;       // ให้ Busout back หรือตัวหลัง เท่ากับทศนิยมอันดับหนึ่ง
            point = 1;      // ให้ไฟที่จุดทศนิยมติด
            wait(0.1);      // หน่วงเวลาเพื่อไม่ให้ค่ามันเปลี่ยนกระทันหันเกินไป
            if (button == 0)   // เมื่อ กด button
            {
                point = 0 ;    // ให้ไฟที่จุดทศนิยมดับ
                break;      // ออกจากลูป
            }
            }
        }
        //Lab 2.1
        if(state == 0)      // เมื่อ state = 0 จะแสดงค่าแรงดันผ่านทางหลอด led
        {
            while(1) {      // วนลูปเพื่อให้ทำเรื่อยๆ
                read = value.read();   // อ่านค่าที่ได้จาก Input analog และเก็บไว้ในตัวแปร read
                read = read * 80;       // ให้ค่า read คูณ 80 เพื่อให้ค่าแรงดันอยู่ในช่วง 0-80 เพื่อง่ายต่อการแบ่งแรงดันเป็นช่วง
                printf("%f \n",read);    // แสดงค่า read บน serial monitor     
                if(button == 0)     // เมื่อมีการกด button 
                {
                    break;  // ออกจากลูป
                }
                if(read < 1)    // เมื่อค่า read น้อยกว่า 1 
                {
                    myleds = 0;   // ให้ Busout myled = 0 ซึ่งคือ 0000 0000
                }    
                else if (read < 10)    // เมื่อค่า read น้อยกว่า 10
                {
                    myleds = 1;   // ให้ Busout myled = 1 ซึ่งคือ 0000 0001
                }    
                else if (read < 20)    // เมื่อค่า read น้อยกว่า 20
                {
                    myleds = 3;   // ให้ Busout myled = 3 ซึ่งคือ 0000 0011
                }
                else if (read < 30)    // เมื่อค่า read น้อยกว่า 30
                {
                    myleds = 7;   // ให้ Busout myled = 7 ซึ่งคือ 0000 0111
                }
                else if (read < 40)    // เมื่อค่า read น้อยกว่า 40
                {
                    myleds = 15;   // ให้ Busout myled = 15 ซึ่งคือ 0000 1111
                }
                else if (read < 50)     // เมื่อค่า read น้อยกว่า 50
                {
                    myleds = 31;   // ให้ Busout myled = 31 ซึ่งคือ 0001 1111
                }
                else if (read < 60)    // เมื่อค่า read น้อยกว่า 60
                {
                    myleds = 63;   // ให้ Busout myled = 63 ซึ่งคือ 0011 1111
                }
                else if (read < 70)    // เมื่อค่า read น้อยกว่า 70
                {
                    myleds = 127;   // ให้ Busout myled = 127 ซึ่งคือ 0111 1111
                }
                else if (read <= 80)     // เมื่อค่า read น้อยกว่าหรือเท่ากับ 80
                {
                    myleds = 255;   // ให้ Busout myled = 255 ซึ่งคือ 1111 1111
                }    
                else    // นอกเหนือจาก if
                {
                    myleds = 0;    // ให้ Busout myled = 0 ซึ่งคือ 0000 0000
                }
            }
        }
    }
  }
