/* MPU9250 Basic Example Code
 by: Kris Winer
 date: April 1, 2014
 license: Beerware - Use this code however you'd like. If you 
 find it useful you can buy me a beer some time.
 
 Demonstrate basic MPU-9250 functionality including parameterizing the register addresses, initializing the sensor, 
 getting properly scaled accelerometer, gyroscope, and magnetometer data out. Added display functions to 
 allow display to on breadboard monitor. Addition of 9 DoF sensor fusion using open source Madgwick and 
 Mahony filter algorithms. Sketch runs on the 3.3 V 8 MHz Pro Mini and the Teensy 3.1.
 
 SDA and SCL should have external pull-up resistors (to 3.3V).
 10k resistors are on the EMSENSR-9250 breakout board.
 
 Hardware setup:
 MPU9250 Breakout --------- Arduino
 VDD ---------------------- 3.3V
 VDDI --------------------- 3.3V
 SDA ----------------------- A4
 SCL ----------------------- A5
 GND ---------------------- GND
 
 Note: The MPU9250 is an I2C sensor and uses the Arduino Wire library. 
 Because the sensor is not 5V tolerant, we are using a 3.3 V 8 MHz Pro Mini or a 3.3 V Teensy 3.1.
 We have disabled the internal pull-ups used by the Wire library in the Wire.h/twi.c utility file.
 We are also using the 400 kHz fast I2C mode by setting the TWI_FREQ  to 400000L /twi.h utility file.
 */
 
//#include "ST_F401_84MHZ.h" 
//F401_init84 myinit(0);
#include "mbed.h"
#include "MPU9250.h"
Serial bt(PA_15, PB_7);


// Using NOKIA 5110 monochrome 84 x 48 pixel display
// pin 9 - Serial clock out (SCLK)
// pin 8 - Serial data out (DIN)
// pin 7 - Data/Command select (D/C)
// pin 5 - LCD chip select (CS)
// pin 6 - LCD reset (RST)
//Adafruit_PCD8544 display = Adafruit_PCD8544(9, 8, 7, 5, 6);

char buffer[14];

   MPU9250 mpu9250;
   Serial pc(USBTX, USBRX);
    float pitchAngle , rollAngle , pitchAngle_rad , rollAngle_rad , yawAngle;
int main()
{
  pc.baud(9600);  
  i2c.frequency(400000);  // use fast (400 kHz) I2C  
  pc.printf("CPU SystemCoreClock is %d Hz\r\n", SystemCoreClock);   
  // Read the WHO_AM_I register, this is a good test of communication
  uint8_t whoami = mpu9250.readByte(MPU9250_ADDRESS, WHO_AM_I_MPU9250);  // Read WHO_AM_I register for MPU-9250
  pc.printf("I AM 0x%x\n\r", whoami); pc.printf("I SHOULD BE 0x73\n\r");
  if (whoami == 0x73) // WHO_AM_I should always be 0x68
  {  
//    pc.printf("MPU9250 WHO_AM_I is 0x%x\n\r", whoami);
//    pc.printf("MPU9250 is online...\n\r");
//    sprintf(buffer, "0x%x", whoami);
//    wait(1);
    mpu9250.resetMPU9250(); // Reset registers to default in preparation for device calibration
    mpu9250.MPU9250SelfTest(SelfTest); // Start by performing self test and reporting values
//    pc.printf("x-axis self test: acceleration trim within : %f % of factory value\n\r", SelfTest[0]);  
//    pc.printf("y-axis self test: acceleration trim within : %f % of factory value\n\r", SelfTest[1]);  
//    pc.printf("z-axis self test: acceleration trim within : %f % of factory value\n\r", SelfTest[2]);  
//    pc.printf("x-axis self test: gyration trim within : %f % of factory value\n\r", SelfTest[3]);  
//    pc.printf("y-axis self test: gyration trim within : %f % of factory value\n\r", SelfTest[4]);  
//    pc.printf("z-axis self test: gyration trim within : %f % of factory value\n\r", SelfTest[5]);  
    mpu9250.calibrateMPU9250(gyroBias, accelBias); // Calibrate gyro and accelerometers, load biases in bias registers  
//    pc.printf("x gyro bias = %f\n\r", gyroBias[0]);
//    pc.printf("y gyro bias = %f\n\r", gyroBias[1]);
//    pc.printf("z gyro bias = %f\n\r", gyroBias[2]);
//    pc.printf("x accel bias = %f\n\r", accelBias[0]);
//    pc.printf("y accel bias = %f\n\r", accelBias[1]);
//    pc.printf("z accel bias = %f\n\r", accelBias[2]);
    wait(1);
    mpu9250.initMPU9250(); 
    pc.printf("MPU9250 initialized for active data mode....\n\r"); // Initialize device for active mode read of acclerometer, gyroscope, and temperature
    mpu9250.initAK8963(magCalibration);
//    pc.printf("AK8963 initialized for active data mode....\n\r"); // Initialize device for active mode read of magnetometer
//    pc.printf("Accelerometer full-scale range = %f  g\n\r", 2.0f*(float)(1<<Ascale));
//    pc.printf("Gyroscope full-scale range = %f  deg/s\n\r", 250.0f*(float)(1<<Gscale));
    //if(Mscale == 0) pc.printf("Magnetometer resolution = 14  bits\n\r");
//    if(Mscale == 1) pc.printf("Magnetometer resolution = 16  bits\n\r");
//    if(Mmode == 2) pc.printf("Magnetometer ODR = 8 Hz\n\r");
//    if(Mmode == 6) pc.printf("Magnetometer ODR = 100 Hz\n\r");
//    wait(1);
   }
   else
   {
    pc.printf("Could not connect to MPU9250: \n\r");
    pc.printf("%#x \n",  whoami);
 
    sprintf(buffer, "WHO_AM_I 0x%x", whoami);
 
    while(1) ; // Loop forever if communication doesn't happen
    }

    mpu9250.getAres(); // Get accelerometer sensitivity
    mpu9250.getGres(); // Get gyro sensitivity
    mpu9250.getMres(); // Get magnetometer sensitivity
//    pc.printf("Accelerometer sensitivity is %f LSB/g \n\r", 1.0f/aRes);
//    pc.printf("Gyroscope sensitivity is %f LSB/deg/s \n\r", 1.0f/gRes);
//    pc.printf("Magnetometer sensitivity is %f LSB/G \n\r", 1.0f/mRes);
//    magbias[0] = +470.;  // User environmental x-axis correction in milliGauss, should be automatically calculated
//    magbias[1] = +120.;  // User environmental x-axis correction in milliGauss
//    magbias[2] = +125.;  // User environmental x-axis correction in milliGauss

 while(1) {
  
  // If intPin goes high, all data registers have new data
  if(mpu9250.readByte(MPU9250_ADDRESS, INT_STATUS) & 0x01) {  // On interrupt, check if data ready interrupt
    mpu9250.readAccelData(accelCount);  // Read the x/y/z adc values   
    // Now we'll calculate the accleration value into actual g's
    ax = (float)accelCount[0]*aRes - accelBias[0];  // get actual g value, this depends on scale being set
    ay = (float)accelCount[1]*aRes - accelBias[1];   
    az = (float)accelCount[2]*aRes - accelBias[2];  
   
    mpu9250.readGyroData(gyroCount);  // Read the x/y/z adc values
    // Calculate the gyro value into actual degrees per second
    gx = (float)gyroCount[0]*gRes - gyroBias[0];  // get actual gyro value, this depends on scale being set
    gy = (float)gyroCount[1]*gRes - gyroBias[1];  
    gz = (float)gyroCount[2]*gRes - gyroBias[2];   
  
    mpu9250.readMagData(magCount);  // Read the x/y/z adc values   
    // Calculate the magnetometer values in milliGauss
    // Include factory calibration per data sheet and user environmental corrections
    if (magCount[0] > magbias_max[0]) magbias_max[0] = magCount[0];
    if (magCount[1] > magbias_max[1]) magbias_max[1] = magCount[1];
    if (magCount[2] > magbias_max[2]) magbias_max[2] = magCount[2];
    
    if (magCount[0] < magbias_min[0]) magbias_min[0] = magCount[0];
    if (magCount[1] < magbias_min[1]) magbias_min[1] = magCount[1];
    if (magCount[2] < magbias_min[2]) magbias_min[2] = magCount[2];
    
    // set offset value to shift in the middle (max. + min.) / 2 
    magbias[0] = ((magbias_max[0] + magbias_min[0])/2);  // User environmental x-axis correction in milliGauss, should be automatically calculated
    magbias[1] = ((magbias_max[1] + magbias_min[1])/2);  // User environmental x-axis correction in milliGauss
    magbias[2] = ((magbias_max[2] + magbias_min[2])/2);  // User environmental x-axis correction in milliGauss 
    
    
    // Calculate the magnetometer values in milliGauss
   // Include factory calibration per data sheet and user environmental corrections
    mx = (float)(magCount[0]- magbias[0])*mRes*magCalibration[0] ;  // get actual magnetometer value, this depends on scale being set
    my = (float)(magCount[1]- magbias[1])*mRes*magCalibration[1] ;  
    mz = (float)(magCount[2]- magbias[2])*mRes*magCalibration[2] ;
  }
//  mpu9250.MadgwickQuaternionUpdate(ax, ay, az, gx*PI/180.0f, gy*PI/180.0f, gz*PI/180.0f,  my,  mx, mz);
  mpu9250.MahonyQuaternionUpdate(ax, ay, az, gx*PI/180.0f, gy*PI/180.0f, gz*PI/180.0f, my, mx, mz);
  
//    pc.printf("ax = %.3f", ax); 
//    pc.printf(" ay = %.3f", ay); 
//    pc.printf(" az = %.3f  \n\r", az); 
//    pc.printf("gx = %.3f", gx); 
//    pc.printf(" gy = %.3f", gy); 
//    pc.printf(" gz = %.3f  deg/s\n\r", gz); 
//    pc.printf("mx = %.3f", mx / 1000); 
//    pc.printf(" my = %.3f", my / 1000); 
//    pc.printf(" mz = %.3f \n\n\r", mz / 1000); 
    pitchAngle = atan2f(ay ,az) * 180/PI;
    if(pitchAngle <= 0)
    {
        pitchAngle = (pitchAngle + 180) + 180;
    }
    rollAngle = atan2f(-ax,ay*sinf(pitchAngle_rad)+az*cosf(pitchAngle_rad/ 180)) * 180/PI;
    pitchAngle_rad = pitchAngle * PI/180;
    rollAngle_rad = rollAngle * PI/180;
//    mx = mz*sinf(rollAngle_rad) - my*cosf(rollAngle_rad);
//    my = mx*cosf(pitchAngle_rad) + my*sinf(pitchAngle_rad)*sinf(rollAngle_rad) + mz*sinf(pitchAngle_rad)*cosf(rollAngle_rad);
    yawAngle = atan2f(my,mx) * 180/PI;
//    pc.printf(" yawAngle = %.1f  \n\n\r", yawAngle);
    pc.printf(" PitchAngle , RollAngle , YawAngle = %.1f %.1f %.1f \n\r", pitchAngle , rollAngle , yawAngle);
    wait_ms(100);
        bt.putc(pitchAngle+rollAngle);
//        bt.putc(rollAngle);
}
}

