/* 
 *　array data transmission and reception　library
 */ 

#ifndef SERIAL_EXTEND_H
#define SERIAL_EXTE_H

#include "mbed.h"

#define __SIZE(array) (sizeof(array) / sizeof(array[0]))


#define MAX_DATA_NUM 10
#define KEY 0//number of first data

/** array data transmission and reception class
 *
 * Example:
 * @code
 * #include"mbed.h"
 * #include"serial_extend.h"
 * #define KEYCODE 0x0A
 *   
 * BusOut check(LED3,LED4);
 *
 * uint8_t send_data[2]={0,0xF};
 * uint8_t get_data[2];
 *
 * serial_extend send(p9,p10);
 * serial_extend get(p28,p27);
 *
 * int main(){
 *    
 * send.write(send_data,KEYCODE);
 * get.read(get_data,KEYCODE);
 * for(int i=1;;i++){
 *    
 *       check = get_data[i];
 *       wait(0.1);
 *       if(i==2){i=0;}
 *   
 *   }
 * }
 * @endcode
 */
 
/*
 typedef enum {     
     write,
     read,
     both
     
     }dir_state;
 */    

class serial_extend{

    public:
    
        /** Create a serial_extend object onnected to the specified serial pin
         *
         * @param tx Serial tx pin
         * @param rx Serial rx pin
         */ 

        serial_extend(PinName tx,PinName rx);
        
        /**reception data
         *
         * @param readData array address
         * @param readKey KEYCODE
         */

        void read_data(uint8_t* readData,uint8_t readKey);
        
        /**send data
         *
         * @param writeData array address
         * @param writeKey KEYCODE
         */

        void write_data(uint8_t* writeData,uint8_t writeKey);

        /**transmit interrupt
         *
         *@param none
         */
        void TX(void);
        
        /**receive interrupt
         *
         *@param none
         */
        void RX(void);
        
        
        void start_read();
        
        void stop_read();
        
        void start_write();
        
        void stop_write();
        
        uint8_t readable_check();

    protected:

        RawSerial __serial__;

        volatile    uint8_t*    __readData;
        volatile    uint8_t     __readSize;
        volatile    uint8_t     __readKey;

        volatile    uint8_t*    __writeData;
        volatile    uint8_t     __writeSize;
        volatile    uint8_t     __writeKey;
        
        volatile    uint8_t     __stop_read;
        volatile    uint8_t     __stop_write;

};
#endif