/*
 * receives_robot_wheel  by Tomoki Hokida
 *
 * motor pins piar
 * motor(p13,p14):motor(p15,p16)
 * motor(p17,p18):motor(p19,p20)
 *
 * Serial Pins
 * packet.arm[0]:arm
 * packet.leg[1]:omni
 * reset 0
 */

#include "mbed.h"
#include "serial_extend.h"

#define DATA_NUM 2 //DATA_NUM[byte]通信 この値はmemcpy使ってるんでxbee_packet構造体のメモリ数といい感じに合わせるようにしてください
#define XBEE_KEY 0xAA //keycode
#define ARM_KEY 0xAA

#define PWM 0.3
#define PWM_SLOW 0.1

#define R_R 0x4
#define R_L 0x1
#define R_U 0x2
#define R_D 0x8

#define L_R 0x10
#define L_L 0x40
#define L_U 0x20 
#define L_D 0x80

#define TIME 0

BusOut check(LED1,LED2,LED3,LED4);
BusOut motors(p13,p14,p15,p16,p17,p18,p19,p20);

PwmOut pwm[4]= {p21,p22,p23,p24};

Serial pc(USBTX,USBRX);

serial_extend xbee(p28,p27);
serial_extend armMbed(p9,p10);

/* data structure */
typedef struct {

    uint8_t arm[1];
    uint8_t leg;

} xbee_packet;

xbee_packet packet;

uint8_t get_data[DATA_NUM]= {0};

uint8_t check_data[2]={0};

int counter=0;

int main()
{

    /* PWM init */
    pwm[0] = PWM;
    pwm[1] = PWM;
    pwm[2] = PWM;
    pwm[3] = PWM;

    xbee_packet *pt_packet=&packet;

    //connect_check();
    
    xbee.start_read();
    xbee.read_data(get_data,XBEE_KEY);
        
    armMbed.start_write();
    armMbed.write_data(pt_packet->arm,ARM_KEY);
    
    counter=0;

    check = 0xFF;
    wait(0.5);

    for(;;) {

        wait_ms(0.5);

        //memcpy(&packet, get_data, DATA_NUM);
        packet.arm[0] = get_data[1];
        packet.leg = get_data[0];

        //check = get_data[1];
            
        check = packet.leg;
        

        /* Stop */
    if(packet.leg==0x0) {
          
          
        motors = 0;
          
        pwm[0] = 0;
        pwm[1] = 0;
        pwm[2] = 0;
        pwm[3] = 0;  
        
       

        }else{
            
         
         if((packet.leg==L_U) || (packet.leg==L_D)){
            
            pwm[0] = PWM_SLOW;
            pwm[1] = PWM_SLOW;
            pwm[2] = PWM_SLOW;
            pwm[3] = PWM_SLOW;
            
            }else{
                           
            pwm[0] = PWM;
            pwm[1] = PWM;
            pwm[2] = PWM;
            pwm[3] = PWM;
           }
    }

        /* Direction of movement */
        if(packet.leg&R_D) motors = 0x55; //01010101 R 接続に気をつけること
        if(packet.leg&R_U) motors = 0xAA; //10101010 L 多分モータードライバの信号線をそれぞれ逆にすればOKかな
        if(packet.leg&R_R) motors = 0x5A; //01011010 U
        if(packet.leg&R_L) motors = 0xA5; //10100101 D

        /* Turn circling */
        if(packet.leg&L_L) motors = 0x66; //01100110
        if(packet.leg&L_R) motors = 0x99; //10011001
        //if(packet.leg&L_U) 
        //if(packet.leg&L_D)
            
    }
}