#include "mbed.h"
#include "TextLCD.h"
#include "MultiSerial.h"
#include "Pswitch.h"

#define DATA_NUM 2
#define KEYCODE 0xAA
#define INTERVAL 12

enum HAND{RIGHT=0, LEFT};
enum FINGER{INDEX=0, MIDDLE};
enum COMPASS{NORTH=0, EAST, SOUTH, WEST};
enum COLOR{YELLOW=0, RED, GREEN, BLUE};


#define INITIAL_TIME 180

LocalFileSystem local("local");

Ticker Watch;

uint8_t GivenTime=INITIAL_TIME;

char *FileName = "/local/GIVEN180.txt";
char *format = "%d\n";
FILE *fp;

void TickTack(void);





uint8_t INdata[DATA_NUM]={0}, EXdata[DATA_NUM]={0};
uint8_t count=0;
bool SW;

void SetUp();
uint8_t LinkBit(bool eight, bool seven, bool six, bool five, bool fore, bool three, bool two, bool one);
void illumination();

Ticker flick;
BusOut LED(LED1, LED2, LED3, LED4);

DigitalOut YLED(p6);

DigitalIn CrossKey[4][2]={{p8, p30}, {p11, p29}, {p15, p28}, {p16, p27}};//p7, p12=reserve
DigitalIn SideKey[2][2]={{p17, p20}, {p18, p19}};
DigitalIn Toggle(p5);
//Pswitch Toggle(p5);

MultiSerial Xbee(p9, p10, write);//or p13, p14
Serial pc(USBTX, USBRX);

TextLCD lcd(p26, p25, p24, p23, p22, p21, TextLCD::LCD16x2); // rs, e, d4-d7

int main() {
    /*fp = fopen(FileName, "r");
    if (fp) {
        fscanf(fp, format, &GivenTime);
        fclose(fp);
    }
    fp = fopen(FileName, "w");
    if (fp) {
        fprintf(fp, format, GivenTime);
        fclose(fp);
    }
    
    if((GivenTime == 0)||(GivenTime > 180)) GivenTime = INITIAL_TIME;
    */
    Watch.attach(TickTack, 1);
    
    
    
    
    SetUp();
    
    Xbee.write_data(EXdata, KEYCODE);
    while(1) {
        
        YLED=!Toggle;
        if(Toggle){
            YLED=!Toggle.read();
        }
        
        if(YLED&&SW) lcd.locate(0, 0), lcd.printf("Setting Mode\n"), SW=0, Watch.detach();
        if((!YLED)&&(!SW)) lcd.locate(0, 0), lcd.printf("Run Mode    \n"), SW=1, Watch.attach(TickTack, 1);
        
        if(Toggle.read()){
            
            
            
            EXdata[0] = LinkBit(!CrossKey[YELLOW][LEFT], !CrossKey[RED][LEFT], !CrossKey[GREEN][LEFT], !CrossKey[BLUE][LEFT], 
                                !CrossKey[YELLOW][RIGHT], !CrossKey[RED][RIGHT], !CrossKey[GREEN][RIGHT], !CrossKey[BLUE][RIGHT]);
            EXdata[1] = LinkBit(0, 0, 0, 1, !SideKey[INDEX][LEFT], !SideKey[MIDDLE][LEFT], !SideKey[INDEX][RIGHT], !SideKey[MIDDLE][RIGHT]);
        }else{
            
            EXdata[0] = 0x00;
            EXdata[1] = 0x00;
            
            /*if((GivenTime!=INITIAL_TIME)&&(LinkBit(0, 0, 0, 0, !SideKey[INDEX][LEFT], !SideKey[MIDDLE][LEFT], !SideKey[INDEX][RIGHT], !SideKey[MIDDLE][RIGHT])==0xF)){
                GivenTime = INITIAL_TIME;
                lcd.locate(0, 1), lcd.printf("%d:%02d            \n", GivenTime/60, GivenTime%60);
            }*/
        }
        
        LED = Toggle*LinkBit(0, 0, 0, 0, !SideKey[INDEX][LEFT], !SideKey[MIDDLE][LEFT], !SideKey[INDEX][RIGHT], !SideKey[MIDDLE][RIGHT]);
        
    }
}

void SetUp(void){
    
    //SW = !Toggle;
    
    if(!Toggle) lcd.locate(0, 0), lcd.printf("Setting Mode\n"), SW=0;
    else lcd.locate(0, 0), lcd.printf("Run Mode    \n"), SW=1;
    
    lcd.locate(0, 1), lcd.printf("%d:%02d            \n", GivenTime/60, GivenTime%60);
    
    CrossKey[NORTH][RIGHT].mode(PullUp);
    CrossKey[EAST][RIGHT].mode(PullUp);
    CrossKey[WEST][RIGHT].mode(PullUp);
    CrossKey[SOUTH][RIGHT].mode(PullUp);
    CrossKey[NORTH][LEFT].mode(PullUp);
    CrossKey[EAST][LEFT].mode(PullUp);
    CrossKey[WEST][LEFT].mode(PullUp);
    CrossKey[SOUTH][LEFT].mode(PullUp);
    
    SideKey[INDEX][RIGHT].mode(PullUp);
    SideKey[MIDDLE][RIGHT].mode(PullUp);
    SideKey[INDEX][LEFT].mode(PullUp);
    SideKey[MIDDLE][LEFT].mode(PullUp);
    
    Toggle.mode(PullUp);
    
    //flick.attach(illumination, INTERVAL);
}
uint8_t LinkBit(bool eight, bool seven, bool six, bool five, bool fore, bool three, bool two, bool one){//0と1を集めて整数を作る
    return 0x80*eight + 0x40*seven + 0x20*six + 0x10*five + 0x08*fore + 0x04*three + 0x02*two + 0x01*one;
}
void illumination(void){//literally
    count++;
    LED = count;
}



void TickTack(void){
    if(!Toggle) return;
    lcd.locate(0, 1);
    
    if(GivenTime==0){
        lcd.printf("GameSet!        \n");
        Watch.detach();
    }
    else{
        GivenTime--;
        /*fp = fopen(FileName, "w");
        fprintf(fp, format, GivenTime);
        fclose(fp);*/
        lcd.printf("%d:%02d            \n", GivenTime/60, GivenTime%60);
    }
}