#include "mbed.h"
#include "TextLCD.h"

#define DATA_NUM 8+2//2byte→KEYCODE（拝啓）とCHECKCODE（敬具） 8byte→やりとりするデータ
#define TX_KEYCODE 0xAA//あちらのKEYCODE
#define RX_KEYCODE 0xAA//こちらのKEYCODE
#define KEY 0//KEYCODEは配列の最初
#define CHECK DATA_NUM-1//CHECKCODEは配列の最後
#define INTERVAL .5

enum HAND{RIGHT=0, LEFT};
enum FINGER{INDEX=0, MIDDLE};
enum COMPASS{NORTH=0, EAST, SOUTH, WEST};
enum COLOR{YELLOW=0, RED, GREEN, BLUE};

volatile uint8_t INdata[DATA_NUM]={0}, EXdata[DATA_NUM]={0};
volatile uint8_t count=0;

void SetUp();
bool GetBit(uint8_t n, uint8_t bit);
uint8_t LinkBit(bool eight, bool seven, bool six, bool five, bool fore, bool three, bool two, bool one);
void illumination();
void TX();
void RX();

Ticker flick;
BusOut LED(LED1, LED2, LED3, LED4);

DigitalOut YLED(p6);

DigitalIn CrossKey[4][2]={{p8, p30}, {p11, p29}, {p15, p28}, {p16, p27}};//p7, p12=reserve
DigitalIn SideKey[2][2]={{p17, p20}, {p18, p19}};
DigitalIn Toggle(p5);

Serial Xbee(p9, p10);//or p13, p14
Serial pc(USBTX, USBRX);
 
TextLCD lcd(p26, p25, p24, p23, p22, p21, TextLCD::LCD16x2); // rs, e, d4-d7

int main() {
    
   SetUp();
   
    while(1) {
        
        YLED=!Toggle;
        
        EXdata[1] = LinkBit(!CrossKey[YELLOW][LEFT], !CrossKey[RED][LEFT], !CrossKey[GREEN][LEFT], !CrossKey[BLUE][LEFT], 
                            !CrossKey[YELLOW][RIGHT], !CrossKey[RED][RIGHT], !CrossKey[GREEN][RIGHT], !CrossKey[BLUE][RIGHT]);
        EXdata[2] = LinkBit(0, 0, 0, 0, !SideKey[INDEX][LEFT], !SideKey[MIDDLE][LEFT], !SideKey[INDEX][RIGHT], !SideKey[MIDDLE][RIGHT]);
        EXdata[3] = LinkBit(0, 0, 0, 0, 0, 0, 0, 0);
        EXdata[4] = LinkBit(0, 0, 0, 0, 0, 0, 0, 0);
        EXdata[5] = LinkBit(0, 0, 0, 0, 0, 0, 0, 0);
        EXdata[6] = LinkBit(0, 0, 0, 0, 0, 0, 0, 0);
        EXdata[7] = LinkBit(0, 0, 0, 0, 0, 0, 0, 0);
        EXdata[8] = LinkBit(0, 0, 0, 0, 0, 0, 0, 0);
    }
}

void SetUp(void){
    
    uint8_t i=1;
    
    lcd.printf("Hello World!\n");
    
    CrossKey[NORTH][RIGHT].mode(PullUp);
    CrossKey[EAST][RIGHT].mode(PullUp);
    CrossKey[WEST][RIGHT].mode(PullUp);
    CrossKey[SOUTH][RIGHT].mode(PullUp);
    CrossKey[NORTH][LEFT].mode(PullUp);
    CrossKey[EAST][LEFT].mode(PullUp);
    CrossKey[WEST][LEFT].mode(PullUp);
    CrossKey[SOUTH][LEFT].mode(PullUp);
    
    SideKey[INDEX][RIGHT].mode(PullUp);
    SideKey[MIDDLE][RIGHT].mode(PullUp);
    SideKey[INDEX][LEFT].mode(PullUp);
    SideKey[MIDDLE][LEFT].mode(PullUp);
    
    Toggle.mode(PullUp);
    
    //flick.attach(illumination, INTERVAL);
    
    Xbee.attach(&TX, Serial::TxIrq);//送信バッファ空き割込み
    //Xbee.attach(&RX, Serial::RxIrq);//受信割込み
    
    Xbee.putc(i);//送信開始
    //i = Xbee.getc();//受信開始
}
bool GetBit(uint8_t n, uint8_t bit){//整数ｎのbitビット目は1か0か．
    return (n>>(bit-1))%2;
}
uint8_t LinkBit(bool eight, bool seven, bool six, bool five, bool fore, bool three, bool two, bool one){//0と1を集めて整数を作る
    return 0x80*eight + 0x40*seven + 0x20*six + 0x10*five + 0x08*fore + 0x04*three + 0x02*two + 0x01*one;
}
void illumination(void){//literally
    count++;
    LED = count;
}
void TX(void){//送信バッファ空き割り込み用関数
    
    static uint8_t Tx=DATA_NUM, i;
    static uint8_t TXdata[DATA_NUM]={TX_KEYCODE};
    static uint8_t TXcheckcode=0;
    
    if(Tx >= DATA_NUM){
        
        TXdata[KEY] = TX_KEYCODE;//Hello.
        
        TXdata[1] = EXdata[1];
        TXdata[2] = EXdata[2];
        TXdata[3] = EXdata[3];
        TXdata[4] = EXdata[4];
        TXdata[5] = EXdata[5];
        TXdata[6] = EXdata[6];
        TXdata[7] = EXdata[7];
        TXdata[8] = EXdata[8];
        //送信するデータ = メインで処理されたデータ
        
        for(i=KEY+1, TXcheckcode=0; i<CHECK; i++){//CHECKCODEの生成
            TXcheckcode ^= TXdata[i];
        }
        
        TXdata[CHECK] = TXcheckcode;//Good bye.
        Tx=0;//配列をリセット
        
    }
    Xbee.putc(TXdata[Tx]);//データを送信する
    Tx++;//配列を入れ替える
    
}
void RX(void){//受信割り込み用関数
    
    static uint8_t Rx=0, i;
    static uint8_t RXdata[DATA_NUM]={RX_KEYCODE};
    static uint8_t RXcheckcode=0;
    
    RXdata[Rx] = Xbee.getc();//データを受け取る
    
    if(RXdata[KEY]==RX_KEYCODE){//KEYCODEが一致したら配列を入れ替える
        Rx++;
    }
    
    if(Rx==CHECK){//CHECKCODEの生成
        for(i=KEY+1, RXcheckcode=0; i<CHECK; i++){
            RXcheckcode ^= RXdata[i];
        }
    }
    
    if(Rx >= DATA_NUM){
        if(RXdata[CHECK]==RXcheckcode){//CHECKCODEが合致したらデータを適用する
            
            INdata[1] = RXdata[1];
            INdata[2] = RXdata[2];
            INdata[3] = RXdata[3];
            INdata[4] = RXdata[4];
            INdata[5] = RXdata[5];
            INdata[6] = RXdata[6];
            INdata[7] = RXdata[7];
            INdata[8] = RXdata[8];
            //メインで処理されるデータ = 受け取ったデータ
            
        }
        Rx=0;//配列をリセット
    }
    
}