#include "mbed.h"
#include "TextLCD.h"
#include "MultiSerial.h"

#define DATA_NUM 2
#define LINKCODE 0xCC
#define LINK_INTERVAL 100
#define KEYCODE 0xAA
#define INTERVAL .5 //12

enum HAND{RIGHT=0, LEFT};
enum FINGER{INDEX=0, MIDDLE};
enum COMPASS{NORTH=0, EAST, SOUTH, WEST};
enum COLOR{YELLOW=0, RED, GREEN, BLUE};

uint8_t TXdata[DATA_NUM]={0};
uint8_t RXdata[DATA_NUM]={0};

uint8_t INdata[DATA_NUM]={0};
uint8_t EXdata[DATA_NUM]={0};

volatile uint8_t count=0;
bool SW;

void SetUp();
void connect_check();
uint8_t LinkBit(bool eight, bool seven, bool six, bool five, bool fore, bool three, bool two, bool one);
void illumination();

Ticker flick;
BusOut LED(LED1, LED2, LED3, LED4);

DigitalOut YLED(p6);

DigitalIn CrossKey[4][2]={{p8, p30}, {p11, p29}, {p15, p28}, {p16, p27}};//p7, p12=reserve
DigitalIn SideKey[2][2]={{p17, p20}, {p18, p19}};
DigitalIn Toggle(p5);

MultiSerial Xbee(p9, p10);
Serial pc(USBTX,USBRX);


int main()
{
    SetUp();
    
    Toggle.mode(PullUp);
    
    connect_check();
    
    TextLCD lcd(p26, p25, p24, p23, p22, p21, TextLCD::LCD16x2); // rs, e, d4-d7
    
    if(TXdata[0]==LINKCODE) lcd.cls(), lcd.printf("3SecondsLater,\n YouCanRun");
    
    wait(3);
    
    YLED=!Toggle;
    if(YLED) lcd.cls(), lcd.printf("Pause Mode\n"), SW=0;
    if(!YLED) lcd.cls(), lcd.printf("Run Mode\n"), SW=1;
    
    Xbee.write_data(EXdata, KEYCODE);
    
    while(1) {
        
        YLED=!Toggle;
        
        if(YLED&&SW) lcd.cls(), lcd.printf("Pause Mode\n"), SW=0;
        if((!YLED)&&(!SW)) lcd.cls(), lcd.printf("Run Mode\n"), SW=1;
        
        if(Toggle){
            
            EXdata[0] = LinkBit(!CrossKey[YELLOW][LEFT], !CrossKey[RED][LEFT], !CrossKey[GREEN][LEFT], !CrossKey[BLUE][LEFT], 
                                !CrossKey[YELLOW][RIGHT], !CrossKey[RED][RIGHT], !CrossKey[GREEN][RIGHT], !CrossKey[BLUE][RIGHT]);
            EXdata[1] = LinkBit(0, 0, 0, 0, !SideKey[INDEX][LEFT], !SideKey[MIDDLE][LEFT], !SideKey[INDEX][RIGHT], !SideKey[MIDDLE][RIGHT]);
        }else{
            
            EXdata[0] = EXdata[1] = 0x00;
        }
        
    }
    
}

void SetUp(void){
    
    CrossKey[NORTH][RIGHT].mode(PullUp);
    CrossKey[EAST][RIGHT].mode(PullUp);
    CrossKey[WEST][RIGHT].mode(PullUp);
    CrossKey[SOUTH][RIGHT].mode(PullUp);
    CrossKey[NORTH][LEFT].mode(PullUp);
    CrossKey[EAST][LEFT].mode(PullUp);
    CrossKey[WEST][LEFT].mode(PullUp);
    CrossKey[SOUTH][LEFT].mode(PullUp);
    
    SideKey[INDEX][RIGHT].mode(PullUp);
    SideKey[MIDDLE][RIGHT].mode(PullUp);
    SideKey[INDEX][LEFT].mode(PullUp);
    SideKey[MIDDLE][LEFT].mode(PullUp);
    
    flick.attach(illumination, INTERVAL);
    flick.detach();
}
void connect_check(void){
    
    while(1){
        
        //YLED = !Toggle;
        //LED = 12;
        Xbee.start_write();
        TXdata[0]=LINKCODE;
        Xbee.write_data(TXdata,KEYCODE);
        wait_ms(100);
        Xbee.stop_write();
        
        Xbee.start_read();
        Xbee.read_data(RXdata,KEYCODE);
        LED = 3;
        wait_ms(100);
        if(RXdata[0]==LINKCODE) break;
        
        Xbee.stop_read();
        
    }
    
}
uint8_t LinkBit(bool eight, bool seven, bool six, bool five, bool fore, bool three, bool two, bool one){//0と1を集めて整数を作る
    return 0x80*eight + 0x40*seven + 0x20*six + 0x10*five + 0x08*fore + 0x04*three + 0x02*two + 0x01*one;
}
void illumination(void){//literally
    count++;
    LED = count;
}