#include "mbed.h"
#include "MultiSerial.h"

#define KEYCODE 0xAA
#define DATA_NUM 1 //DATA_NUM[byte]通信
#define TIME_LIMIT 1.0//腕が閉まっても動けるのはTIME_LIMIT[s]まで
#define ARM_REV 1.0
#define TURN_REV 0.25
 
uint8_t INdata[DATA_NUM]={0}, EXdata[DATA_NUM]={0};
volatile uint8_t count=0;
 
enum Logic{OFF=0, ON};//殆どはモーターのON，OFFに使う
enum Arm{R=0, L, C};//右腕と左腕
enum Clip{Open=0, Close};//開ける動作と閉める動作
enum Revolution{CW=0, CCW};//正回転，逆回転(上体回転)
enum Compass{N=0, E, W, S};//マシンの回転
 
BusOut LED(LED1, LED2, LED3, LED4);//確認用
BusIn mt(p19, p20, p17, p18);
//DigitalIn Ninety[2]={p5, p6};//R, L
DigitalIn OneEighty[2]={p5, p6};//R, L
InterruptIn HandSW[3]={p7, p8, p9};//p14, p15, p16//R, L, C
DigitalIn TurnSW[2]={p11, p12};//
PwmOut HandSpeed[2]={p23, p24};
PwmOut TurnSpeed(p22);//p22
DigitalOut Hand[2][2]={{p28, p27}, {p26, p25}};//{p17, p18}, {p19, p20}
//ex)Hand[R][Close]=ON;
DigitalOut Turn[2]={p29, p30};//p29, p30
//ex)Turn[CW]=ON;
Serial pc(USBTX, USBRX);
MultiSerial Xbee(p13, p14, read);
Ticker flick;
Timeout Touch;//腕で掴むときの安全対策
 
void StopCatching(void);//literally
void StopLeaving(void);//literally
void StartCatching(void);//literally
void StartLeaving(void);//literally
void RightCatch(void);//右腕のリミットスイッチ
void LeftCatch(void);//左腕のリミットスイッチ
void CenterCatch(void);//中央のリミットスイッチ
void illumination(void);//literally
void SetUp(void);//literally
bool GetBit(uint8_t n, uint8_t bit);//literally

int main(void) {
    
    SetUp();
    
    while(1) {
        
        //INdata[0] = ~mt;
        
        if(GetBit(INdata[0], 2)==OFF) StopLeaving();//停止
        
        if((GetBit(INdata[0], 1)+GetBit(INdata[0], 2))==1){//同時押し防止
            if(GetBit(INdata[0], 1)==true) CenterCatch();//中央のリミットスイッチがうまく動作しなかった場合の保険
            if(GetBit(INdata[0], 2)==true){//腕を広げる動作はマニュアル操作
                StopCatching();//停止
                Touch.detach();//ワンショットタイマー停止
                Hand[R][Open] = GetBit(INdata[0], 2)&&OneEighty[R];
                Hand[L][Open] = GetBit(INdata[0], 2)&&OneEighty[L];
            }
        }
        
        if(((!HandSW[R])&&(!HandSW[L]))&&((Hand[R][Close]&&Hand[L][Close])==ON)){//どちらも押されたら停止
            StopCatching();//停止
            Touch.detach();//ワンショットタイマー停止
        }
        
        if(!OneEighty[R]) Hand[R][Open]=OFF;
        if(!OneEighty[L]) Hand[L][Open]=OFF;
        //if(!Ninety[R]) Hand[R][Close]=OFF;
        //if(!Ninety[L]) Hand[L][Close]=OFF;
        
        //if((!Ninety[R])&&(!Ninety[L])){//どちらも押されたら停止
        //    StopCatching();//停止
        //    Touch.detach();//ワンショットタイマー停止
        //}
        
        LED = ((0x01 * !HandSW[R]) | (0x02 * !HandSW[L]) | (0x04 * !HandSW[C]) | (0x08 * ((!OneEighty[R])&&(!OneEighty[L])) ));
        
        //上体回転
        
        if(GetBit(INdata[0], 3)==OFF) Turn[CW] = OFF;//停止
        if(GetBit(INdata[0], 4)==OFF) Turn[CCW] = OFF;//停止
        
        if((GetBit(INdata[0], 3)+GetBit(INdata[0], 4))==1){//同時押し防止
            
            Turn[CW] = GetBit(INdata[0], 3)&&TurnSW[N];//押されていて，かつリミットスイッチが押されていなかったら右回転
            Turn[CCW] = GetBit(INdata[0], 4)&&TurnSW[E];//押されていて，かつリミットスイッチが押されていなかったら左回転
            
        }
    }
}
 
void StopCatching(void){//停止
    Hand[R][Close]=Hand[L][Close]=OFF;
}
void StopLeaving(void){//停止
    Hand[R][Open]=Hand[L][Open]=OFF;
}
void StartCatching(void){//掴む（リミットスイッチが押されてなければ）
 
    if((!HandSW[R])&&(!HandSW[L])){
        Hand[R][Close] = Hand[L][Close] = OFF;
    }
    else{
        
        //Hand[R][Close]=Ninety[R];
        //Hand[L][Close]=Ninety[L];
        
        Hand[R][Close]=ON;
        Hand[L][Close]=ON;
            
    }
    
}
void StartLeaving(void){//離す（リミットスイッチが押されてなければ）
    Hand[R][Open]=OneEighty[R];
    Hand[L][Open]=OneEighty[L];
}
void RightCatch(void){//右腕のリミットスイッチ
    if((!HandSW[R])&&(!HandSW[L])){//どちらも押されたら停止
        StopCatching();//停止
        Touch.detach();//ワンショットタイマー停止
    }
}
void LeftCatch(void){//左腕のリミットスイッチ
    if((!HandSW[R])&&(!HandSW[L])){//どちらも押されたら停止
        StopCatching();//停止
        Touch.detach();//ワンショットタイマー停止
    }
}
void CenterCatch(void){//中央のリミットスイッチ
 
    if((!OneEighty[R])&&(!OneEighty[L])){
        Touch.attach(StopCatching, TIME_LIMIT);//TIME_LIMIT[s]で停止
        StartCatching();
    }
    
}
void illumination(void){//literally
    count++;
    LED = count;
}
void SetUp(void){//literally
    
    mt.mode(PullUp);
    
    HandSpeed[R] = HandSpeed[L] = ARM_REV;
    TurnSpeed = TURN_REV;
    
    //flick.attach(illumination, .5);
    
    HandSW[R].mode(PullUp);
    HandSW[L].mode(PullUp);
    HandSW[C].mode(PullUp);
    HandSW[R].fall(RightCatch);
    HandSW[L].fall(LeftCatch);
    HandSW[C].fall(CenterCatch);
    
    OneEighty[R].mode(PullUp);
    OneEighty[L].mode(PullUp);
    //Ninety[R].mode(PullUp);
    //Ninety[L].mode(PullUp);
    
    TurnSW[N].mode(PullUp);
    TurnSW[E].mode(PullUp);
    
    Xbee.read_data(INdata, KEYCODE);
}
bool GetBit(uint8_t n, uint8_t bit){//n=8[bit]data, bit = 1-8(8bitのデータから指定bitの数値を読み取る)
    return (n>>(bit-1))%2;
}     