/* 
 *mbed Multibyte Serial Library
 */

#include "mbed.h"
#include "MultiSerial.h"
#include "RawSerial.h"

    
        MultiSerial::MultiSerial(PinName tx,PinName rx) : __serial__(tx,rx){}
    
        void MultiSerial::safety(){
            
            for(int l = 0;l <= __readSize;l++){
                
                __readData[l] = 0;
        
                }
            }
    
        void MultiSerial::start_write(){
            
            __serial__.attach(this,&MultiSerial::TX,RawSerial::TxIrq);
            __serial__.putc(1);
            
            }
                
        void MultiSerial::start_read(){
            
            __serial__.attach(this,&MultiSerial::RX,RawSerial::RxIrq);
            uint8_t k = __serial__.getc();
            
            __first_bit = k;
            
            }

        void MultiSerial::read_data(uint8_t* readData,uint8_t readKey,int readSize){

            __readData = readData;
            __readSize = readSize;
            __readKey = readKey;
        }


        void MultiSerial::write_data(uint8_t* writeData,uint8_t writeKey,int writeSize){

            __writeData = writeData;
            __writeSize = writeSize;
            __writeKey = writeKey;
        }

        void MultiSerial::TX(void){//送信バッファ空き割り込み用関数

            static uint8_t tx = __writeSize+2, i;
            static uint8_t txData[MAX_DATA_NUM] = {__writeKey};   
            static uint8_t tx_checkcode = 0;
            
            if(tx >= __writeSize+2){
                txData[KEY] = __writeKey;

                for(int k = 1;k <= __writeSize;k++){
                    txData[k] = __writeData[k-1];
                }

                //送るデータ = センサ等のデータ
                for(i = KEY+1, tx_checkcode = 0; i < __writeSize+1; i++){
                    tx_checkcode ^= txData[i];
                }//CHECKCODE作成
                txData[__writeSize+1] = tx_checkcode;
                tx = 0;
            }
            __serial__.putc(txData[tx]);
            tx++;
        }//受信割り込み用関数

        void MultiSerial::RX(void){
            
            static uint8_t rx = 0, i;
            static uint8_t rxData[MAX_DATA_NUM] = {__readKey};
            static uint8_t rx_checkcode = 0;

            rxData[rx] = __serial__.getc();

            if(rxData[KEY] == __readKey){
                rx++;
            }

            if(rx == __readSize+1){
                for(i = KEY+1, rx_checkcode = 0; i < __readSize+1; i++){
                    rx_checkcode ^= rxData[i];
                }//CHECKCODE作成
            }

            if(rx >= __readSize+2){
                if(rxData[__readSize+1] == rx_checkcode){
                        
                    __check_rx = 1; 
                    
                    xbee_check.attach(this,&MultiSerial::safety,0.5);   
                        
                    for(int m = 1;m <= __readSize;m++){
                        __readData[m-1] = rxData[m];
                    }

                    //使うデータ = 受け取ったデータ
                }else{
                    
                    __check_rx = 0;
                    
                    }
                rx=0;
            }
        }
        
        uint8_t MultiSerial::readable_check(){
            
            return __serial__.readable();
            
            }

        uint8_t MultiSerial::re_first_bit(){
            
            return __first_bit;
            
            }
            
        void MultiSerial::check_rx_wait(){
                
                if(__check_rx == 0) NVIC_SystemReset();
            
            }
            