/* 
 *mbed Multibyte Serial Library
 *This comment is available in Japanese only
 */



#ifndef MBED_MULTISERIAL
#define MBED_MULTISERIAL

#include"mbed.h"

#define __SIZE(array) (sizeof(array) / sizeof(array[0]))

/** 多バイト通信用クラス　
 *
 * Example:
 * @code
 *     #include"mbed.h"
 *   #include"MultiSerial.h"
 *   
 *   MultiSerial test1(p9,p10);
 *   MultiSerial test2(USBTX,USBRX);
 *
 *   int main(){
 *
 *   uint8_t data1[5]={0};
 *   test1.write(data1, 0xAA);
 *   uint8_t data2[8]={0};
 *   test2.read(data2, 0xAA);    
 *   
 *   
 *   for(;;);  
 * }
 * @endcode
 */


class MultiSerial {

    public:
    
       /** 多バイト通信用オブジェクト作成　Serialにそのままつなげるよ
        *
        * @param tx Serial tx pin
        * @param rx Serial rx pin
        */  
        MultiSerial(PinName tx,PinName rx);
        
       /**データ読み込みするよ　
        *
        * @param value 読み込み先の配列アドレス
        * @param size 配列の要素数
        * @param keycode 多バイト通信のキーコード
        */
        void start_read(uint8_t* value,int size,uint8_t keycode);

       /**データｶｷｺするよ
        *
        * @param value 送るデーターの配列アドレス
        * @param size 配列の要素数
        * @param keycode 多バイト通信のキーコード
        */

        void start_write(uint8_t* value,int size,uint8_t keycode);
/*        
        void writeAttach(void (*func)()){
             __serial__.attach(func,Serial::TxIrq);
            }
            
        void readAttach(void(*func)()){     
        __serial__.attach(func,Serial::RxIrq);
            }
*/          
        /**シリアル通信　受信割り込み　ルーチン　
        * @param none
        */           
        void RX(void);
       /**シリアル通信　送信バッファ空き割り込みルーチン
        * @param none
        */
        void TX(void);
           
       /**　データ読み込み起動するよ
        *
        * @param value 読み込み先の配列アドレス
        * @param keycode 多バイト通信のキーコード
        */            
        void read(uint8_t* value,uint8_t keycode);
       /**データｶｷｺ起動するよ　
        *
        * @param value 送信データの配列アドレス
        * @param keycode 多バイト通信のキーコード
        */            

        void write(uint8_t* value,uint8_t keycode);
        
protected:
  
    Serial __serial__;
    uint8_t *__readData;
    uint8_t *__writeData;
    int __readSize;
    int __writeSize;
    uint8_t __readKey;
    uint8_t __writeKey;
    
};
#endif
