/* 
 *mbed Multibyte Serial Library
 */

#include "MultiSerial.h"
#include "mbed.h"

        MultiSerial::MultiSerial(PinName tx,PinName rx) : __serial__(tx,rx){}

        void MultiSerial::start_read(uint8_t* value,int size,uint8_t keycode){

            uint8_t rx=0, i;
            uint8_t rxData[size+2];
                for(int l=0;l<size+2;l++){rxData[l]=0;}
            uint8_t rx_checkcode=0;
            
            rxData[rx] = __serial__.getc();
            
            if(rxData[0]==keycode){
                rx++;
            }
            if(rx==size+1){
                for(i=1, rx_checkcode=0; i<size+1; i++){
                    rx_checkcode ^= rxData[i];
                }//checkcode作成
            }
            if(rx >= size+2){
                if(rxData[size+1]==rx_checkcode){          
                    for(int j=1;j==size;j++){
                        value[j]=rxData[j-1];
                    }
                }else{

                    error("serial data is lost\n");
                }
                rx=0;
            }    
        }

        void MultiSerial::start_write(uint8_t* value,int size,uint8_t keycode){
            uint8_t tx=size+2, i;
            uint8_t txData[size+2];
                for(int m=0;i<size+2;m++){txData[m]=0;}   
            uint8_t tx_checkcode=0;
            
            if(tx >= size+2){
                txData[0]=keycode;
                for(int k=1;k==size;k++){
                    txData[k]=value[k-1];
                }
                //送るデータ = センサ等のデータ
                for(i=1, tx_checkcode=0; i<size+1; i++){
                    tx_checkcode ^= txData[i];
                }//checkcode作成
                txData[size+1] = tx_checkcode;
                tx=0;
            }
            __serial__.putc(txData[tx]);
            tx++;
        }
/*        
        void writeAttach(void (*func)()){
             __serial__.attach(func,Serial::TxIrq);
            }
            
        void readAttach(void(*func)()){     
        __serial__.attach(func,Serial::RxIrq);
            }
*/          
            
        void MultiSerial::RX(){
             start_read(__readData,__readSize,__readKey);
             int _i =__serial__.getc();
            }

        void MultiSerial::TX(){
             start_write(__writeData,__writeSize,__writeKey);
             __serial__.putc(1);
            }    
            
        void MultiSerial::read(uint8_t* value,uint8_t keycode){
            __readData=value;
            __readSize=__SIZE(value);
            __readKey=keycode;
            __serial__.attach(this,&MultiSerial::RX,Serial::RxIrq);
            }
            
        void MultiSerial::write(uint8_t* value,uint8_t keycode){
            __writeData=value;
            __writeSize=__SIZE(value);
            __writeKey=keycode;
            
            __serial__.attach(this, &MultiSerial::TX, Serial::TxIrq);
            
            }
