/* 
 *mbed Multibyte Serial Library
 *This comment is available in Japanese only
 */
 

#ifndef MULTISERIAL_H
#define MULTISERIAL_H

#include "mbed.h"

#define __SIZE(array) (sizeof(array) / sizeof(array[0]))


#define MAX_DATA_NUM 10
#define KEY 0//number of first data

/** 多バイト通信用クラス　
 *
 * Example:
 * @code
 * #include"mbed.h"
 * #include"MultiSerial.h"   
 * BusOut check(LED3,LED4); 

 * uint8_t send_data[2]={0,0xF};
 * uint8_t get_data[2];
 * MultiSerial send(p9,p10);
 * MultiSerial get(p28,p27);
 *
 * int main(){
 *    
 * send.write(send_data,0x0A);
 * get.read(get_data,0x0A);
 * for(int i=1;;i++){
 *    
 *       check = get_data[i];
 *       wait(0.1);
 *       if(i==2){i=0;}
 *   
 *   }
 * }
 * @endcode
 */
 
/*
 typedef enum {     
     write,
     read,
     both
     
     }dir_state;
 */    

class MultiSerial{

    public:
    
        /** 多バイト通信用オブジェクト作成　Serialにそのままつなげるよ
         *
         * @param tx Serial tx pin
         * @param rx Serial rx pin
         * @param state 通信方向 read,write,both
         */ 

        MultiSerial(PinName tx,PinName rx);
        
        /**データ読み込みするよ　
         *
         * @param readData 読み込み先の配列アドレス
         * @param readKey 多バイト通信のキーコード
         */

        void read_data(uint8_t* readData,uint8_t readKey);
        
        /**データｶｷｺするよ
         *
         * @param writeData 送るデーターの配列アドレス
         * @param writeKey 多バイト通信のキーコード
         */

        void write_data(uint8_t* writeData,uint8_t writeKey);

        /**送信割り込み用関数
         *
         *@param none
         */
        void TX(void);
        /**受信割り込み用関数
         *
         *@param none
         */
        void RX(void);
        
        void start_read();
        
        void stop_read();
        
        void start_write();
        
        void stop_write();
        
        uint8_t readable_check();
        
        uint8_t re_first_bit();

    protected:

        Serial __serial__;

        volatile    uint8_t*    __readData;
        volatile    uint8_t     __readSize;
        volatile    uint8_t     __readKey;

        volatile    uint8_t*    __writeData;
        volatile    uint8_t     __writeSize;
        volatile    uint8_t     __writeKey;
        
        volatile    uint8_t     __stop_read;
        volatile    uint8_t     __stop_write;
        
        volatile    uint8_t     __first_bit;

};
#endif