/* 
 *mbed Multibyte Serial Library
 */

#include "mbed.h"
#include "MultiSerial.h"
#include "RawSerial.h"

    
        MultiSerial::MultiSerial(PinName tx,PinName rx) : __serial__(tx,rx){
            /*
            switch(state){
            
            case read:
            {
            __serial__.attach(this,&MultiSerial::RX,Serial::RxIrq);
            uint8_t k = __serial__.getc();
            break;
            }
            
            case write:
            {
            __serial__.attach(this,&MultiSerial::TX,Serial::TxIrq);
            __serial__.putc(1);
            break;
            }
            
            case both:
            {
             __serial__.attach(this,&MultiSerial::RX,Serial::RxIrq);
            uint8_t m = __serial__.getc();
            __serial__.attach(this,&MultiSerial::TX,Serial::TxIrq);
            __serial__.putc(1);
            }
            
        }
        */
    }
    
        void MultiSerial::start_write(){
            
            __stop_write = 0;
            __serial__.attach(this,&MultiSerial::TX,RawSerial::TxIrq);
            __serial__.putc(1);
            
            }
            
        void MultiSerial::stop_write(){
            
            __stop_write  = 1;
            
            }
            
            
        void MultiSerial::start_read(){
            
            __stop_read = 0;
            __serial__.attach(this,&MultiSerial::RX,RawSerial::RxIrq);
            uint8_t k = __serial__.getc();
            
            }
            
        void MultiSerial::stop_read(){
            
            __stop_read = 1;
            
            }

        void MultiSerial::read_data(uint8_t* readData,uint8_t readKey){

            __readData = readData;
            __readSize = __SIZE(__readData);
            __readKey = readKey;
        }


        void MultiSerial::write_data(uint8_t* writeData,uint8_t writeKey){

            __writeData=writeData;
            __writeSize = __SIZE(__writeData);
            __writeKey = writeKey;
        }


        void MultiSerial::TX(void){//送信バッファ空き割り込み用関数

            if(__stop_write==1){return;} 

            static uint8_t tx=__writeSize+2, i;
            static uint8_t txData[MAX_DATA_NUM]={__writeKey};   
            static uint8_t tx_checkcode=0;
            if(tx >= __writeSize+2){
                txData[KEY] = __writeKey;

                for(int k=1;k<=__writeSize;k++){
                    txData[k] = __writeData[k-1];
                }

                //送るデータ = センサ等のデータ
                for(i=KEY+1, tx_checkcode=0; i<__writeSize+1; i++){
                    tx_checkcode ^= txData[i];
                }//CHECKCODE作成
                txData[__writeSize+1] = tx_checkcode;
                tx=0;
            }
            __serial__.putc(txData[tx]);
            tx++;
        }//受信割り込み用関数

        void MultiSerial::RX(void){
            
            if(__stop_read==1){return;}
            
            static uint8_t rx=0, i;
            static uint8_t rxData[MAX_DATA_NUM]={__readKey};
            static uint8_t rx_checkcode=0;

            rxData[rx] = __serial__.getc();

            if(rxData[KEY]==__readKey){
                rx++;
            }

            if(rx==__readSize+1){
                for(i=KEY+1, rx_checkcode=0; i<__readSize+1; i++){
                    rx_checkcode ^= rxData[i];
                }//CHECKCODE作成
            }

            if(rx >= __readSize+2){
                if(rxData[__readSize+1]==rx_checkcode){

                    for(int m=1;m<=__readSize;m++){
                        __readData[m-1] = rxData[m];
                    }

                    //使うデータ = 受け取ったデータ
                }
                rx=0;
            }
        }
        
        uint8_t MultiSerial::readable_check(){
            
            return __serial__.readable();
            
            }
