/*押したらLEDが点く．*/
#include "mbed.h"

#define DATA_NUM 8+2//2byte→KEYCODE（拝啓）とCHECKCODE（敬具） 8byte→やりとりするデータ
#define TX_KEYCODE 0xBB//あちらのKEYCODE
#define RX_KEYCODE 0xAA//こちらのKEYCODE
#define KEY 0//KEYCODEは配列の最初
#define CHECK DATA_NUM-1//CHECKCODEは配列の最後

BusIn SW8(p21, p22, p23, p24, p25, p26, p27, p28);
BusOut LED8(p13, p14, p15, p16, p17, p18, p19, p20);
BusOut LED(LED1, LED2, LED3, LED4);
Serial pc(USBTX, USBRX);
RawSerial Xbee(p9, p10);

volatile uint8_t INdata[DATA_NUM]={0}, EXdata[DATA_NUM]={0};

uint8_t GetBit(uint8_t n, uint8_t bit){//整数ｎのbitビット目は1か0か．
    return (n>>(bit-1))%2;
}
void TX(void){//送信バッファ空き割り込み用関数
    
    static uint8_t Tx=DATA_NUM, i;
    static uint8_t TXdata[DATA_NUM]={TX_KEYCODE};
    static uint8_t TXcheckcode=0;
    
    if(Tx >= DATA_NUM){
        
        TXdata[KEY] = TX_KEYCODE;//Hello.
        
        TXdata[1] = EXdata[1];
        TXdata[2] = EXdata[2];
        TXdata[3] = EXdata[3];
        TXdata[4] = EXdata[4];
        TXdata[5] = EXdata[5];
        TXdata[6] = EXdata[6];
        TXdata[7] = EXdata[7];
        TXdata[8] = EXdata[8];
        //送信するデータ = メインで処理されたデータ
        
        for(i=KEY+1, TXcheckcode=0; i<CHECK; i++){//CHECKCODEの生成
            TXcheckcode ^= TXdata[i];
        }
        
        TXdata[CHECK] = TXcheckcode;//Good bye.
        Tx=0;//配列をリセット
        
    }
    Xbee.putc(TXdata[Tx]);//データを送信する
    Tx++;//配列を入れ替える
    
}
void RX(void){//受信割り込み用関数

    static uint8_t Rx=0, i;
    static uint8_t RXdata[DATA_NUM]={RX_KEYCODE};
    static uint8_t RXcheckcode=0;
    
    RXdata[Rx] = Xbee.getc();//データを受け取る
    
    if(RXdata[KEY]==RX_KEYCODE){//KEYCODEが一致したら配列を入れ替える
        Rx++;
    }
    
    if(Rx==CHECK){//CHECKCODEの生成
        for(i=KEY+1, RXcheckcode=0; i<CHECK; i++){
            RXcheckcode ^= RXdata[i];
        }
    }
    
    if(Rx >= DATA_NUM){
        if(RXdata[CHECK]==RXcheckcode){//CHECKCODEが合致したらデータを適用する
            
            INdata[1] = RXdata[1];
            INdata[2] = RXdata[2];
            INdata[3] = RXdata[3];
            INdata[4] = RXdata[4];
            INdata[5] = RXdata[5];
            INdata[6] = RXdata[6];
            INdata[7] = RXdata[7];
            INdata[8] = RXdata[8];
            //メインで処理されるデータ = 受け取ったデータ
            
        }
        Rx=0;//配列をリセット
    }
    
}

int main(void) {
    
    int i=1;
    
    SW8.mode(PullUp);//プルアップ
    
    Xbee.attach(&TX, Serial::TxIrq);//送信バッファ空き割込み
    Xbee.attach(&RX, Serial::RxIrq);//受信割込み
    
    Xbee.putc(i);//送信開始
    i = Xbee.getc();//受信開始
    
    
    
    
    while(1){
        LED = 15;
        EXdata[1] = ~SW8 & 0x01;//A0000000
        EXdata[2] = ~SW8 & 0x02;//0B000000
        EXdata[3] = ~SW8 & 0x04;//00C00000
        EXdata[4] = ~SW8 & 0x08;//000D0000
        EXdata[5] = ~SW8 & 0x10;//0000E000
        EXdata[6] = ~SW8 & 0x20;//00000F00
        EXdata[7] = ~SW8 & 0x40;//000000G0
        EXdata[8] = ~SW8 & 0x80;//0000000H
        
        LED8 = INdata[1] | INdata[2] | INdata[3] | INdata[4] | INdata[5] | INdata[6] | INdata[7] | INdata[8];
        ///A0000000
        ///0B000000
        ///00C00000
        ///000D0000
        ///0000E000
        ///00000F00
        ///000000G0
        ///0000000H
        //+________
        ///ABCDEFGH
        
    }
}