/*
覚書

変数や特別な関数はだいたいハンガリアン記法の独自版を使用してますでもキャメル法？的なものも混ざってカオス
全くおすすめできない
_ = 宣言系?につける
_ii - InterruptIn
_bo - BusOut
_do - DigitalOut
_po - PwmOut
_to - TimeOut
_tm - Timer
_at - attach(少しほかのと意味が違う気もするが) 

i  - int
u8 - uint8_t
b  - bool

@About function 
void MotorState()
    モーター出力のBusOutのbit配置を配列に置き換え

void RunAway()
    前進中，後進中を表す変数(u8Way)をリセットする

void LegUDCount()
    足を何回上げたか数える

void SpeedMeasure()
    速さを足上げ-足下げまでの検知の時間から計算する
    
void _atWaitStop0()
    Timeoutの割り込み先関数
    delay timeを作る※ほかのものと統合予定    

void _atMotorStop()
    Timeoutの割り込み先関数
    モーターの動きを止める

void _atTempraStop()
    Timeoutの割り込み先関数
    足のぐるぐる用モーターの動きを止める
    
void _atFallPhoto()
    interruptInの関数
    足を上げたり下げたり
    




・・・InterruptIn の配列の0が前のセンサとする．


ちゃんと回ったか理解していない恐れがあるのでもう一度しっかりプログラムをチェック
*/

#include "mbed.h"

#define MOTOR_NUM 2
#define PWM_LEVEL 1.0
#define MOTOR_UP_TIME 0.060
#define MOTOR_DOWN_TIME 0.065
#define WAIT_TIME 0.035
#define TEMPRA_TIME 1.0/**/ 
#define DISTANCE 3.5/*センサ間距離[mm]*/


Serial pc(USBTX,USBRX);

InterruptIn _iiPhoto[MOTOR_NUM] = {p5,p6};


DigitalOut _doLed[MOTOR_NUM] = {LED1,LED2};//
BusOut _boMotor(p19,p20);//output motor for leg up down 
BusOut _boTempra(p17,p18);//output motor for back leg move
PwmOut _poMotor(p21);//up down motor pwm level 
PwmOut _poTempra(p22);//back leg motor pwm level

Timeout _toMotor[MOTOR_NUM];
Timeout _toWait[MOTOR_NUM/2];
Timeout _toTempra;
Timer _tmSpeed;
Timer _tmRt_way;//Reset way timer

volatile bool bMotor[MOTOR_NUM] = {0},bWait[MOTOR_NUM/2] = {0};
volatile bool bMotorState=0;
volatile bool bFlag = 1;
volatile uint8_t u8Ct1[MOTOR_NUM] = {0},u8Ct2[MOTOR_NUM] = {1,1};//uint8_t Count{1,2}[]
volatile uint8_t u8Ct_leg;//足上げ回数記録
volatile uint8_t u8My_motor = 0;//uint8_t memory motor  最終的に足が上がっていたら下げるような
volatile uint8_t u8Sp_motor;
volatile uint8_t u8Way = 0;


void MotorState(){
/*
uint8_t GetBit(uint8_t n, uint8_t bit)
     return (n >>(bit-1))%2;
}by takamastu
*/
    uint8_t i;
    
    for (i = 0; i < MOTOR_NUM*2 ; i++){
        bMotor[i] = ( _boMotor >> 1-i )%2;
    }    
}


void RunAway(){//向き調整のお手伝い
/*    
    flagが上がっている間向き固定
    指定回数足をあげたら初期動作に戻る，連続して足のアゲサゲが行われなかった場合向きをリセット→進行方向の変更可能   
  */
    int iNum = 4;
    if(u8Ct_leg > iNum){
        u8Ct_leg = 0;
    }
    if(_tmRt_way.read() > 5.0){
        u8Ct_leg = 0;
        _tmRt_way.stop();
        _tmRt_way.reset();
    }
    
    
}

void LegUDCount(){//足を上げた回数を記録
    RunAway();
    if(bMotorState&&bFlag){
        u8Ct_leg++;
        bFlag = 0;
    }else if(!bMotorState){
        bFlag = 1;
    }   
    
    
}

void SpeedMeasure(){//速さ計測目的 天ぷらの揚げ時間に影響
    
    if(bMotorState&&(_tmSpeed.read()>0)){//速さ計測.どちら向きでもとりあえず速さを出す
        _tmSpeed.start();
        
    }else if(!bMotorState){
        _tmSpeed.stop();
        u8Sp_motor = _tmSpeed.read_ms() / DISTANCE;
        _tmSpeed.reset();
    }

}


void _atWaitStop0(){//atatch Time Stop0
//end delay time
    bWait[0] =  0;
    
}


void _atMotorStop0(){
    _boMotor = _boMotor & 0x01; 
    //01  leg Up stop
    _doLed[1] = 0;

    
}

void _atMotorStop1(){
    _toWait[0].attach(&_atWaitStop0,WAIT_TIME);
    _boMotor = _boMotor & 0x02; 
    //10  leg down stop
    _doLed[1] = 0;

    
}

void _atTempraStop(){
    _boMotor = _boTempra & 0x02;   
    
}


void _atFallPhoto0(){
    if(!u8Ct_leg){
        u8Way = 1;
        _tmRt_way.start();
    }
    if(_boMotor == 0){//怪しいかもしれない
        if(!bWait[0] && !u8Ct1[0] && !u8Ct1[1]&&(u8Way == 1)){
            u8Ct1[0] = 1;
            //legs up start
            _toMotor[0].attach(&_atMotorStop0,MOTOR_UP_TIME);
            _boMotor = _boMotor | 0x02;//10
            _doLed[0] = 1;
            _toTempra.attach(&_atTempraStop,u8Sp_motor*0.001+0.01);//速さから天ぷらの揚げ時間を変更
            _boTempra = _boTempra | 0x01;
        
            bMotorState = 1;
        

        }else if(u8Ct1[0]){
            u8Ct1[0] = 2;
        
        }else if((u8Ct1[1] == u8Ct2[0])&&(u8Way == 2)){
            u8Ct1[1]=0;
            u8Ct2[0]=1;
            //legs down
            _toMotor[1].attach(&_atMotorStop1,MOTOR_DOWN_TIME);
            _boMotor = _boMotor | 0x01;// 01
            _doLed[1] = 1;
            bWait[0] = 1;
        
            bMotorState = 0; 
          
        }else if(u8Way == 2){
            u8Ct2[0] = 2;
    
        }   
    }
}


void _atFallPhoto1(){
    if(!u8Ct_leg){
        u8Way = 2;
        _tmRt_way.start();
    }
    if(_boMotor==0){
        
        if(!bWait[0] && !u8Ct1[1] && !u8Ct1[0]&&(u8Way == 2)){
            u8Ct1[1] = 1;
            //legs up
            _toMotor[0].attach(&_atMotorStop0,MOTOR_UP_TIME);
            _boMotor = _boMotor | 0x02;// 10
            _doLed[0] = 1;
        
            bMotorState = 1;
                
        }else if(u8Ct1[1]){
            u8Ct1[1] = 2;
                
        }else if((u8Ct1[0] == u8Ct2[1])&&(u8Way == 1)){
            u8Ct1[0]=0;
            u8Ct2[1]=1;
            //legs down
            _toMotor[1].attach(&_atMotorStop1,MOTOR_DOWN_TIME);
            _boMotor = _boMotor | 0x01;// 01
            _doLed[1] = 1;
            bWait[0] = 1;
            
            bMotorState = 0; 
            
        }else if(u8Way ==1){
            u8Ct2[1] = 2;
            
        }
    }

}


int main() {
        
    _iiPhoto[0].mode(PullUp);
    _iiPhoto[1].mode(PullUp);
    
    _iiPhoto[0].fall(_atFallPhoto0);
    _iiPhoto[1].fall(_atFallPhoto1);
    
    _poMotor = PWM_LEVEL ;
    _poTempra = PWM_LEVEL;
    
    _tmSpeed.reset();
    wait(0.5);

    while(1) {
        SpeedMeasure();
        //足上げかいすう
        LegUDCount();


    }
}
