// A class library to display Azoteq IQS62x registers on a terminal

// Copyright 2017 Azoteq. Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions: The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

// More info on IQS624 sensor IC: http://bit.ly/IQS624_info

// IQS624 1-minute youtube video: http://bit.ly/IQS624Video

#include "IQSdisplayTerminal.h"

// constructor
#if defined(TARGET_TEENSY3_1) || defined (TARGET_TEENSY3_2) || IQS_USE_USBSERIAL
IQS62xDisplay::IQS62xDisplay() : USBSerial() // use our own USB device stack
#else
IQS62xDisplay::IQS62xDisplay() : Serial(USBTX,USBRX) // use mbed default serial port
#endif

{    
    frameCounter=0;
    baud(DISPLAY_BAUD_RATE);
}    

#if defined(TARGET_TEENSY3_1) || defined (TARGET_TEENSY3_2) || IQS_USE_USBSERIAL
void IQS62xDisplay::baud(int baudRate){}
#endif

// display a startup message to serial port
void IQS62xDisplay::helloMessage(bool waitForUser) {
    puts("\x1b[2J  \x1b[?25l  \x1b[H"); // ANSII/VT100 codes to clear screen, invisible cursor, home cursor
    printf("           IQS624 Register Display\r\n\r\n"); 
    printf("To get a smooth screen refresh effect, use a terminal program that supports ANSI/VT100 escape codes such as Tera Term.\r\n\r\n");
    printf("Handy hint - In many terminal programs, Alt-B (break) will reset your Nucleo Board.\r\n\r\n");
    printf("Press any key to continue...\r\n");
    if ( waitForUser ) while( ! readable() ); // wait for keypress to continue
    puts("\x1b[2J  \x1b[?25l  \x1b[H"); // ANSII/VT100 codes to clear screen, invisible cursor, home cursor
}

// show headings and I2C error count
void IQS62xDisplay::showStatus(int I2Cspeed, int I2CErrorCount) {
    frameCounter++;
    puts("\x1b[H"); // ANSI/VT100 command for cursor home
    printf("\t\t\t"); 
    printf("\t IQS624 Register Display\r\n\r\n"); // heading
    printf("\t Frame number %06d", frameCounter);
    printf("\t I2C Speed %dk", I2Cspeed/1000);
    printf("\t I2C Errors %d", I2CErrorCount);
}

// formatted hex display of IQS62x registers
void IQS62xDisplay::showRegisters(char * buffer) {
    #define ShowLine(FROM,TO) for(int j=(FROM);j<=(TO);j++)printf("%02x ",buffer[j])
    printf("\r\n\r\n  Device ID (43) [00] "); ShowLine(0x00,0x0f);
    printf("\r\n\r\n    System Flags [10] "); ShowLine(0x10,0x1f);
    printf("\r\n\r\n        Counters [20] "); ShowLine(0x20,0x2f);
    printf("\r\n\r\n        Averages [30] "); ShowLine(0x30,0x3f);
    printf("\r\n\r\n     Touch Setup [40] "); ShowLine(0x40,0x4f);
    printf("\r\n\r\n Touch Threshold [50] "); ShowLine(0x50,0x5f);
    printf("\r\n\r\n Small Usr Setup [60] "); ShowLine(0x60,0x6f);
    printf("\r\n\r\n   Hall Settings [70] "); ShowLine(0x70,0x7f);
    printf("\r\n\r\n    Wheel Values [80] "); ShowLine(0x80,0x8f);
    printf("\r\n\r\n    System Setup [d0] "); ShowLine(0xd0,0xdf);
    printf("\r\n\r\n");
}