// A class library to display Azoteq IQS62x registers on a terminal

// More info on IQS624 sensor IC: http://bit.ly/IQS624_info

#include "mbed.h"

#define DISPLAY_BAUD_RATE 115200 /* baud rate of serial terminal */


#if defined(TARGET_TEENSY3_1) || defined (TARGET_TEENSY3_2) || IQS_USE_USBSERIAL
#warning if USBSerial.h can't be found import this library: developer.mbed.org/users/mbed_official/code/USBDevice
// USBSerial comes from the library http://developer.mbed.org/users/mbed_official/code/USBDevice which MUST be imported for Teensy
#include "USBSerial.h"
// USBSerial comes from the library http://developer.mbed.org/users/mbed_official/code/USBDevice which MUST be imported for Teensy
#endif

#if defined(TARGET_TEENSY3_1) || defined (TARGET_TEENSY3_2) || IQS_USE_USBSERIAL
class IQS62xDisplay : public USBSerial { // use our own USB serial port (requires USB driver to be installed, see Teensy Website)
    public: void baud(int baudRate);
#else
class IQS62xDisplay : public Serial { // use ARM mbed virtual serial port
#endif

  public:
    int frameCounter;
    IQS62xDisplay(); // constructor
    void helloMessage(bool); // show startup message
    void showStatus(int,int); // show headings and I2C Error Count
    void showRegisters(char *); // show IQS62x registers
};