// A class library for Azoteq IQS62x devices

// More info on IQS62x sensor ICs: http://www.azoteq.com/products/proxfusion?mbed

// ProxFusion 5-minute YouTube video: http://bit.ly/proxfusion-video

#include "mbed.h"

// Verify these 3 pin definitions if your hardware is not on the list of tested boards

#if defined (TARGET_LPC1768) || defined (TARGET_LPC11U24)
#define IQS_I2C_CLOCK_PIN p27       /* on LPC1768/LPC11U24 this is marked as p10 */
#define IQS_I2C_DATA_PIN p28        /* on LPC1768/LPC11U24 this is marked as p9 */
#define IQS_READY_PIN p26           /* on LPC1768/LPC11U24 this is marked as p8 */

#else
// If your board has an Arduino interface the definitions below will likely work, also works for Teensy
#define IQS_I2C_CLOCK_PIN I2C_SCL   /* on NUCLEO boards this is marked as SCL/D15 on CN5 */
//#define IQS_I2C_CLOCK_PIN PA_9   /* on NUCLEO boards this is marked as SCL/D15 on CN5 */
#define IQS_I2C_DATA_PIN I2C_SDA    /* on NUCLEO boards this is marked as SDA/D14 on CN5 */
//#define IQS_I2C_DATA_PIN PA_10   /* on NUCLEO boards this is marked as SDA/D14 on CN5 */
#define IQS_READY_PIN D2            /* on NUCLEO boards this is marked as D2 on CN9 */
//#define IQS_READY_PIN PA_12      /* on NUCLEO boards this is marked as D2 on CN9 */
#endif

#define I2C_ADR (0x44 << 1) /* I2C address of IQS62x */
#define I2CSPEED 100000 /* I2C clock speed */
#define NUMBER_OF_REGISTERS 224 /* number of registers to read from IQS62x */
#define I2CBufferSize 256 /* size of I2C read buffer */

class IQS62xIO { // basic IQS62x block read and write
  public:
    I2C i2c; // I2C interface
    DigitalIn IQSready; // ready pin
    const static int I2Cspeed = I2CSPEED; // I2C clock rate
    int I2CErrorCount; // number of I2C errors
    int IQSframes; // number of reads we've done
    char I2CBuffer    [I2CBufferSize]; // I2C read buffer

    char writeFlag       [I2CBufferSize]; // to remember our if we wrote to this register
    char lastWrite       [I2CBufferSize]; // to remember what we wrote to this register
    char lastRead        [I2CBufferSize]; // to remember what we read from this register
    char readChanges     [I2CBufferSize]; // to log changes from previous read
    char readChangesEver [I2CBufferSize]; // to log changes from previous read BUT this one never forgets a change
    char writeChanges    [I2CBufferSize]; // to log changes from what we wrote

    char * registers; // pointer to I2C read buffer
    IQS62xIO(); // constructor    
    
    void writeRegister(int address, int data); // write a byte to a register
    void configure(); // write configuration registers of the IQS62x    
    void readIqsRegisters(int start, int count); // starting at "start" read count registers
    void waitForIqsReady(); // wait for IQS62x ready signal
    char * getTable( int ); // fetch one of the tables containing changes in register values
    // an enumerated type we use in main to select one of the tables of changes
};

// used with getTable()
enum changeType {
    color_nothing=0, // no change table selected
    color_any_register_that_ever_changed=1, // a table to flag any register that ever changed
    color_any_register_that_changed_in_the_previous_20_reads=2, // a table to flag any register that changed in the last 20 reads
    color_any_register_that_was_written_or_initialized=3, // a table to flag any register we wrote to or initialized
    color_any_register_that_was_written_but_then_changed=4 // a table to flag any register we wrote to but then its value changed
};
