// A class library for Azoteq IQS62x devices
#include "IQS62x.h"

// constructor
IQS62xIO::IQS62xIO() : 
    i2c( IQS_I2C_DATA_PIN, IQS_I2C_CLOCK_PIN ), // first run the constructor for mbed class I2C
    IQSready( IQS_READY_PIN )                   // first run the constructor for mbed class DigitalIn
{    
    registers = I2CBuffer; // pointer to the receive buffer
    I2CErrorCount = 0; // reset I2C error count
    i2c.frequency( I2Cspeed ); // I2C clock frequency
}    

// write some configuration data to the IQS62x
void IQS62xIO::configure() {
    const static char system_register_setup_data [] = { 0xd0, 0x40 }; 
    int numberOfBytes = sizeof( system_register_setup_data );
    waitForReady();
    // clear the reset bit in register 0xd0
    if(0!=i2c.write(I2C_ADR,system_register_setup_data,numberOfBytes,false)) 
        I2CErrorCount++;
}

// read all registers from the IQS62x
void IQS62xIO::readAll() {
    waitForReady();
    const static char i2c_start_address [] = { 0x0 };
    int numberOfBytes = sizeof( i2c_start_address );
    // write 0 to the IQS62x address register
    if(0!=i2c.write(I2C_ADR,i2c_start_address,numberOfBytes,false)) 
        I2CErrorCount++;
    waitForReady();
    memset(I2CBuffer,0x55,I2CBufferSize); // "clear" i2c receive buffer
    numberOfBytes = NUMBER_OF_REGISTERS;
    // read register values into a buffer
    if(0!=i2c.read(I2C_ADR,I2CBuffer,numberOfBytes,false))
        I2CErrorCount++;
}

// wait for IQS62x to provide a ready signal (low) on IQS62x_ready pin
void IQS62xIO::waitForReady() {
    int timeout=0; 
    while (1) {
        if(IQSready==1) break;
        if (timeout++ > 1000000) goto fatal_error; 
    }
    timeout=0;
    while (1) {
        if(IQSready==0) break;
        if (timeout++ > 1000000) goto fatal_error;
    }
    return;
    fatal_error:
        error ("Fatal Error: IQS62x ready pin is not toggling");
}