// A class library for Azoteq IQS62x devices
#include "mbed.h"

// Verify these 3 pin definitions if your hardware is not on the list of tested boards

#if defined (TARGET_LPC1768) || defined (TARGET_LPC11U24)
#define IQS_I2C_CLOCK_PIN p27       /* on LPC1768/LPC11U24 this is marked as p10 */
#define IQS_I2C_DATA_PIN p28        /* on LPC1768/LPC11U24 this is marked as p9 */
#define IQS_READY_PIN p26           /* on LPC1768/LPC11U24 this is marked as p8 */

#else
// If your board has an Arduino interface the definitions below will likely work
#define IQS_I2C_CLOCK_PIN I2C_SCL   /* on NUCLEO boards this is marked as SCL/D15 on CN5 */
#define IQS_I2C_DATA_PIN I2C_SDA    /* on NUCLEO boards this is marked as SDA/D14 on CN5 */
#define IQS_READY_PIN D2            /* on NUCLEO boards this is marked as D2 on CN9 */
#endif

#define I2C_ADR (0x44 << 1) /* I2C address of IQS62x */
#define I2CSPEED 100000 /* I2C clock speed */
#define NUMBER_OF_REGISTERS 224 /* number of registers to read from IQS62x */
#define I2CBufferSize 256 /* size of I2C read buffer */

class IQS62xIO { // basic IQS62x block read and write
  public:
    I2C i2c; // I2C interface
    DigitalIn IQSready; // ready pin
    const static int I2Cspeed = I2CSPEED; // I2C clock rate
    int I2CErrorCount; // number of I2C errors
    char I2CBuffer [I2CBufferSize]; // I2C read buffer
    char * registers; // pointer to I2C read buffer
    IQS62xIO(); // constructor    
    
    void configure(); // write configuration registers of the IQS62x    
    void readAll(); // read all registers from the IQS62x     
    void waitForReady(); // wait for IQS62x ready signal
};