#include "IQS62x.h"

// Function to configure/initialize the IQS624
// Uses the configuration data provided in "IQS624_Init.h"
// The file "IQS624_Init.h" can be created/exported by the Azoteq software tools
// The included version of "IQS624_Init.h" is a robust demo configuration
// More info on IQS624: http://www.azoteq.com/products/proxfusion/iqs624?mbed

#include "IQS624_Init.h"

void IQS62xIO::configure() {

/* Change the Prox Sensor Settings */
/* Memory Map Position 0x40 - 0x49 */
  writeRegister( 0x40,  PXS_SETTINGS_0     );
  writeRegister( 0x41,  PXS_SETTINGS_1     );
  writeRegister( 0x42,  PXS_SETTINGS_2     );      
  writeRegister( 0x43,  PXS_SETTINGS_3     );
  writeRegister( 0x44,  PXS_SETTINGS_4     );
  writeRegister( 0x45,  PXS_SETTINGS_5     );
  writeRegister( 0x46,  PXS_SETTINGS_6     );     
  writeRegister( 0x47,  PXS_SETTINGS_7     );
  writeRegister( 0x48,  PXS_SETTINGS_8     );
  writeRegister( 0x49,  PXS_SETTINGS_9     );     

/* Change the Prox UI Settings */
/* Memory Map Position 0x50 - 0x54 */
  writeRegister( 0x50,  PXS_UI_SETTINGS_0  );
  writeRegister( 0x51,  PXS_UI_SETTINGS_1  );
  writeRegister( 0x52,  PXS_UI_SETTINGS_2  );
  writeRegister( 0x53,  PXS_UI_SETTINGS_3  );
  writeRegister( 0x54,  PXS_UI_SETTINGS_4  );

/* Change the HALL Sensor Settings */
/* Memory Map Position 0x70 - 0x7A */
  writeRegister( 0x70,  HALL_SETTINGS_0    );
  writeRegister( 0x71,  HALL_SETTINGS_1    );
  writeRegister( 0x72,  HALL_SETTINGS_2    );
  writeRegister( 0x73,  HALL_SETTINGS_3    );
  writeRegister( 0x74,  HALL_SETTINGS_4    );
  writeRegister( 0x75,  HALL_SETTINGS_5    );
  writeRegister( 0x76,  HALL_SETTINGS_6    );
  writeRegister( 0x77,  HALL_SETTINGS_7    );
  writeRegister( 0x78,  HALL_SETTINGS_8    );
  writeRegister( 0x79,  HALL_SETTINGS_9    );
  writeRegister( 0x7a,  HALL_SETTINGS_10   );           

/* Change the Device & PMU Settings */
/* Memory Map Position 0xD0 - 0xD7 */
  writeRegister( 0xd0,  SYSTEM_SETTINGS        );
  writeRegister( 0xd1,  ACTIVE_CHS             );            
  writeRegister( 0xd2,  PMU_SETTINGS           );
  writeRegister( 0xd3,  REPORT_RATES_TIMINGS_0 );    
  writeRegister( 0xd4,  REPORT_RATES_TIMINGS_1 );
  writeRegister( 0xd5,  REPORT_RATES_TIMINGS_2 );
  writeRegister( 0xd6,  REPORT_RATES_TIMINGS_3 );
  writeRegister( 0xd7,  REPORT_RATES_TIMINGS_4 );

}
// end of IQS624_Init.cpp