// IQS624-HelloWorld.cpp

// Hello World program for Azoteq IQS624 ultra low power sensor for 2D magnetic angle, capacitive touch and inductive proximity sensor.

// More info on IQS624 sensor IC: http://www.azoteq.com/products/proxfusion/iqs624?mbed

// IQS624 1-minute youtube video: http://bit.ly/IQS624Video

// Copyright 2017 Azoteq. Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions: The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

// Output is via the USB debug serial port to a terminal program

// Tested on the following MBED hardware - mostly using Azoteq-to-Arduino Adapter Boards
// Note: When compiling for new hardware, use "Compile All" to rebuild everything
// Note 2: If you get "unkown target type" in USBxxx.h, remove the USB library
//  1. ST Micro Nucleo-L152RE   Azoteq Adapter Boards: AZP675E02, AZP694A02, AZP690E01
//  2. ST Micro Nucleo-F401RE   Azoteq Adapter Boards: AZP675E02, AZP694A02, AZP690E01
//  3. ST Micro Nucleo-L476RG   Azoteq Adapter Boards: AZP675E02, AZP694A02, AZP690E01
//  4. ST Micro Nucleo-L053R8   Azoteq Adapter Boards: AZP675E02, AZP694A02, AZP690E01
//  5. ST Micro Nucleo-F446RE   Azoteq Adapter Boards: AZP675E02, AZP694A02, AZP690E01
//  6. ST Micro Disco-F746NG    Azoteq Adapter Boards: AZP675E02, AZP694A02, AZP690E01
//  7. Freescale FRDM-KL46Z     Azoteq Adapter Boards: AZP675E02, AZP694A02, AZP690E01
//  8. Freescale FRDM-KL25Z     Azoteq Adapter Boards: AZP675E02, AZP694A02, AZP690E01
//  9. mbed LPC1768             Azoteq adapter AZP690E01 [SDA,SCL,RDY] wired to LPC1768 [p28,p27,p26]
// 10. mbed LPC11U24            Azoteq adapter AZP690E01 [SDA,SCL,RDY] wired to LPC11U24 [p28,p27,p26]

// These two boards additionally require the USBDevice library: https://developer.mbed.org/users/mbed_official/code/USBDevice/
// 11. Teensy 3.1               Azoteq adapter AZP690E01 [SDA,SCL,RDY] wired to Teensy 3.1 [p18,p19,p2]
// 12. Teensy 3.2               Azoteq adapter AZP690E01 [SDA,SCL,RDY] wired to Teensy 3.2 [p18,p19,p2]

// Direct wiring of ST Micro Nucleo boards to AZP690E01 (IQS621-EVAL-1 board)
// CN10-3 = SCL, CN10-5 = SDA, CN10-33 = RDY, CN11 = GND, CN7-16 = 3.3V


#include "mbed.h"
#include "IQS62x.h"
#include "IQSdisplayTerminal.h"

IQS62xDisplay terminal;   // class to display IQS62x registers on a terminal
IQS62xIO iqs62x;          // class for basic IQS62x block read and write

int main() {
    terminal.helloMessage(false); // say hello but don't wait for a keypress
    iqs62x.configure(); // configure the IC
    char * color = iqs62x.getTable(color_any_register_that_changed_in_the_previous_20_reads) ;
    while(1) {
        iqs62x.readIqsRegisters(0,NUMBER_OF_REGISTERS); // read all the registers
        terminal.showStatus(iqs62x.I2Cspeed,iqs62x.I2CErrorCount); // show heading and number of I2C errors
        terminal.showRegisters(iqs62x.registers, color, false); // display registers, color the registers that changed
    }    
}
// end of IQS624_HelloWorld.cpp