/*
* This file contains all the necessary settings for the IQS622 and this file can
* be changed from the GUI or edited here
* File:   IQS622_init.h
* Author: Azoteq
*/

#ifndef IQS622_INIT_H
#define IQS622_INIT_H

/* Change the Prox Sensor Settings */
/* Memory Map Position 0x40 - 0x4D */
#define PXS_SETTINGS_0                      0x01
#define PXS_SETTINGS_1                      0x02
#define PXS_SETTINGS_2                      0x57
#define PXS_SETTINGS_3                      0x57
#define PXS_SETTINGS_4                      0x18
#define PXS_SETTINGS_5                      0xD0
#define PXS_SETTINGS_6                      0x06
#define PXS_SETTINGS_7                      0x06
#define PXS_SETTINGS_8                      0x00
#define PXS_SETTINGS_9                      0x01
#define PXS_SETTINGS_10                     0x22
#define PXS_SETTINGS_11                     0xB1
#define PXS_SETTINGS_12                     0x81
#define PXS_SETTINGS_13                     0x03

/* Change the Prox UI Settings */
/* Memory Map Position 0x50 - 0x54 */
#define PXS_UI_SETTINGS_0                   0x14
#define PXS_UI_SETTINGS_1                   0x20
#define PXS_UI_SETTINGS_2                   0x14
#define PXS_UI_SETTINGS_3                   0x25
#define PXS_UI_SETTINGS_4                   0x28

/* Change the SAR UI Settings */
/* Memory Map Position 0x60 - 0x65 */
#define SAR_UI_SETTINGS_0                   0x14
#define SAR_UI_SETTINGS_1                   0x25
#define SAR_UI_SETTINGS_2                   0x05
#define SAR_UI_SETTINGS_3                   0x14
#define SAR_UI_SETTINGS_4                   0x20
#define SAR_UI_SETTINGS_5                   0x28

/* Change the Light Sensor Settings */
/* Memory Map Position 0x70 - 0x75 */
#define LIGHT_SENSOR_SETTINGS_0             0x14
#define LIGHT_SENSOR_SETTINGS_1             0x81
#define LIGHT_SENSOR_SETTINGS_2             0x07
#define LIGHT_SENSOR_SETTINGS_3             0x81
#define LIGHT_SENSOR_SETTINGS_4             0x01
#define LIGHT_SENSOR_SETTINGS_5             0x01

/* Change the Active IR UI Settings */
/* Memory Map Position 0x90 - 0x92 */
#define IR_UI_SETTINGS_0                    0x11
#define IR_UI_SETTINGS_1                    0x19
#define IR_UI_SETTINGS_2                    0x19
#define IR_UI_SETTINGS_3                    0x01

/* Change the HALL Sensor Settings */
/* Memory Map Position 0xA0 - 0xA3 */
#define HALL_SENSOR_SETTINGS_0              0x03
#define HALL_SENSOR_SETTINGS_1              0x50
#define HALL_SENSOR_SETTINGS_2              0x20
#define HALL_SENSOR_SETTINGS_3              0x4A

/* Change the HALL Switch UI Settings */
/* Memory Map Position 0xB0 - 0xB2 */
#define HALL_UI_SETTINGS_0                  0x11
#define HALL_UI_SETTINGS_1                  0x19
#define HALL_UI_SETTINGS_2                  0x19

/* Change the Device & PMU Settings */
/* Memory Map Position 0xD0 - 0xD7 */
#define SYSTEM_SETTINGS                     0x08
#define ACTIVE_CHS                          0x7F
#define PMU_SETTINGS                        0x03
#define REPORT_RATES_TIMINGS_0              0x10
#define REPORT_RATES_TIMINGS_1              0x64
#define REPORT_RATES_TIMINGS_2              0x0A
#define REPORT_RATES_TIMINGS_3              0x14
#define GLOBAL_EVENT_MASK                   0x00

#endif  /* IQS622_INIT_H */
