/*
* This file contains all the necessary settings for the IQS621 and this file can
* be changed from the GUI or edited here
* File:   IQS621_init.h
* Author: Azoteq
*/

#ifndef IQS621_INIT_H
#define IQS621_INIT_H

/* Change the Prox Sensor Settings */
/* Memory Map Position 0x40 - 0x4D */
#define PXS_SETTINGS_0                      0x01
#define PXS_SETTINGS_1                      0x01
#define PXS_SETTINGS_2                      0x57
#define PXS_SETTINGS_3                      0x57
#define PXS_SETTINGS_4                      0x18
#define PXS_SETTINGS_5                      0xD0
#define PXS_SETTINGS_6                      0x06
#define PXS_SETTINGS_7                      0x06
#define PXS_SETTINGS_8                      0x00
#define PXS_SETTINGS_9                      0x01
#define PXS_SETTINGS_10                     0xA1
#define PXS_SETTINGS_11                     0x65
#define PXS_SETTINGS_12                     0x44
#define PXS_SETTINGS_13                     0x0C

/* Change the Prox UI Settings */
/* Memory Map Position 0x50 - 0x54 */
#define PXS_UI_SETTINGS_0                   0x14
#define PXS_UI_SETTINGS_1                   0x20
#define PXS_UI_SETTINGS_2                   0x14
#define PXS_UI_SETTINGS_3                   0x20
#define PXS_UI_SETTINGS_4                   0x28

/* Change the Metal Detect UI Settings */
/* Memory Map Position 0x60 - 0x63 */
#define METAL_UI_SETTINGS_0                 0x00
#define METAL_UI_SETTINGS_1                 0x01
#define METAL_UI_SETTINGS_2                 0x14
#define METAL_UI_SETTINGS_3                 0x20

/* Change the Light Sensor Settings */
/* Memory Map Position 0x70 - 0x73 */
#define LIGHT_SENSOR_SETTINGS_0             0x14
#define LIGHT_SENSOR_SETTINGS_1             0x80
#define LIGHT_SENSOR_SETTINGS_2             0x07
#define LIGHT_SENSOR_SETTINGS_3             0x00

/* Change the ALS UI Settings */
/* Memory Map Position 0x80 - 0x83 */
#define ALS_UI_SETTINGS_0                   0x0A
#define ALS_UI_SETTINGS_1                   0x0A
#define ALS_UI_SETTINGS_2                   0x27
#define ALS_UI_SETTINGS_3                   0x04

/* Change the HALL Sensor Settings */
/* Memory Map Position 0x90 - 0x93 */
#define HALL_SENSOR_SETTINGS_0              0x03
#define HALL_SENSOR_SETTINGS_1              0x50
#define HALL_SENSOR_SETTINGS_2              0xB0
#define HALL_SENSOR_SETTINGS_3              0x0A

/* Change the HALL Switch UI Settings */
/* Memory Map Position 0xA0 - 0xA2 */
#define HALL_UI_SETTINGS_0                  0x11
#define HALL_UI_SETTINGS_1                  0x19
#define HALL_UI_SETTINGS_2                  0x19

/* Change the Temperature UI Settings */
/* Memory Map Position 0xC0 - 0xC3 */
#define TEMP_UI_SETTINGS_0                  0x00
#define TEMP_UI_SETTINGS_1                  0x08
#define TEMP_UI_SETTINGS_2                  0x79
#define TEMP_UI_SETTINGS_3                  0xFF

/* Change the Device & PMU Settings */
/* Memory Map Position 0xD0 - 0xD7 */
#define SYSTEM_SETTINGS                     0x08
#define ACTIVE_CHS                          0x7F
#define PMU_SETTINGS                        0x03
#define REPORT_RATES_TIMINGS_0              0x10
#define REPORT_RATES_TIMINGS_1              0x64
#define REPORT_RATES_TIMINGS_2              0x0A
#define REPORT_RATES_TIMINGS_3              0x14
#define GLOBAL_EVENT_MASK                   0x00

#endif  /* IQS621_INIT_H */
