#include "IQS62x.h"

// Function to configure/initialize the IQS624
// Uses the configuration data provided in "IQS624_Init.h"
// The file "IQS624_Init.h" can be created/exported by the Azoteq software tools
// The included version of "IQS624_Init.h" is a robust demo configuration
// More info on IQS624: http://www.azoteq.com/products/proxfusion/iqs624?mbed

#include "IQS621_Init.h"

void IQS62xIO::configure() {

/* Change the Prox Sensor Settings 0 */
/* Memory Map Position 0x40 - 0x4D */
  writeRegister( 0x40,  PXS_SETTINGS_0     );
  writeRegister( 0x41,  PXS_SETTINGS_1     );
  writeRegister( 0x42,  PXS_SETTINGS_2     );      
  writeRegister( 0x43,  PXS_SETTINGS_3     );
  writeRegister( 0x44,  PXS_SETTINGS_4     );
  writeRegister( 0x45,  PXS_SETTINGS_5     );
  writeRegister( 0x46,  PXS_SETTINGS_6     );     
  writeRegister( 0x47,  PXS_SETTINGS_7     );
  writeRegister( 0x48,  PXS_SETTINGS_8     );
  writeRegister( 0x49,  PXS_SETTINGS_9     );     
  writeRegister( 0x4a,  PXS_SETTINGS_10    );     
  writeRegister( 0x4b,  PXS_SETTINGS_11    );     
  writeRegister( 0x4c,  PXS_SETTINGS_12    );     
  writeRegister( 0x4d,  PXS_SETTINGS_13    );     

/* Change the Prox UI Settings */
/* Memory Map Position 0x50 - 0x54 */
  writeRegister( 0x50,  PXS_UI_SETTINGS_0    );
  writeRegister( 0x51,  PXS_UI_SETTINGS_1    );
  writeRegister( 0x52,  PXS_UI_SETTINGS_2    );
  writeRegister( 0x53,  PXS_UI_SETTINGS_3    );
  writeRegister( 0x54,  PXS_UI_SETTINGS_4    );


/* Change the Metal Detect UI Settings */
/* Memory Map Position 0x60 - 0x63 */
  writeRegister( 0x60,  METAL_UI_SETTINGS_0  );
  writeRegister( 0x61,  METAL_UI_SETTINGS_1  );
  writeRegister( 0x62,  METAL_UI_SETTINGS_2  );
  writeRegister( 0x63,  METAL_UI_SETTINGS_3  );
  
/* Change the Light Sensor Settings */
/* Memory Map Position 0x70 - 0x73 */
  writeRegister( 0x70,  LIGHT_SENSOR_SETTINGS_0    );
  writeRegister( 0x71,  LIGHT_SENSOR_SETTINGS_1    );
  writeRegister( 0x72,  LIGHT_SENSOR_SETTINGS_2    );
  writeRegister( 0x73,  LIGHT_SENSOR_SETTINGS_3    );
  
/* Change the ALS UI Settings */
/* Memory Map Position 0x80 - 0x83 */
  writeRegister( 0x80,  ALS_UI_SETTINGS_0    );
  writeRegister( 0x81,  ALS_UI_SETTINGS_1    );
  writeRegister( 0x82,  ALS_UI_SETTINGS_2    );
  writeRegister( 0x83,  ALS_UI_SETTINGS_3    );

/* Change the HALL Sensor Settings */
/* Memory Map Position 0x90 - 0x93 */
  writeRegister( 0x90,  HALL_SENSOR_SETTINGS_0    );
  writeRegister( 0x91,  HALL_SENSOR_SETTINGS_1    );
  writeRegister( 0x92,  HALL_SENSOR_SETTINGS_2    );
  writeRegister( 0x93,  HALL_SENSOR_SETTINGS_3    );

/* Change the HALL Switch UI Settings */
/* Memory Map Position 0xA0 - 0xA2 */
  writeRegister( 0xa0,  HALL_UI_SETTINGS_0    );
  writeRegister( 0xa1,  HALL_UI_SETTINGS_1    );
  writeRegister( 0xa2,  HALL_UI_SETTINGS_2    );

/* Change the Temperature UI Settings */
/* Memory Map Position 0xC0 - 0xC3 */
  writeRegister( 0xc0,  TEMP_UI_SETTINGS_0    );
  writeRegister( 0xc1,  TEMP_UI_SETTINGS_1    );
  writeRegister( 0xc2,  TEMP_UI_SETTINGS_2    );
  writeRegister( 0xc3,  TEMP_UI_SETTINGS_3    );

/* Change the Device & PMU Settings */
/* Memory Map Position 0xD0 - 0xD7 */
  writeRegister( 0xd0,  SYSTEM_SETTINGS        );
  writeRegister( 0xd1,  ACTIVE_CHS             );            
  writeRegister( 0xd2,  PMU_SETTINGS           );
  writeRegister( 0xd3,  REPORT_RATES_TIMINGS_0 );    
  writeRegister( 0xd4,  REPORT_RATES_TIMINGS_1 );
  writeRegister( 0xd5,  REPORT_RATES_TIMINGS_2 );
// fix  writeRegister( 0xd6,  REPORT_RATES_TIMINGS_3 );
// fix  writeRegister( 0xd7,  GLOBAL_EVENT_MASK      );

}
// end of IQS624_Init.cpp