#include "IQS62x.h"

// Function to configure/initialize the IQS620
// Uses the configuration data provided in "IQS620_Init.h"
// The file "IQS620_Init.h" can be created/exported by the Azoteq software tools
// The included version of "IQS620_Init.h" is a robust demo configuration
// More info on IQS620: http://www.azoteq.com/products/proxfusion/iqs620?mbed

#include "IQS620_Init.h"

void IQS62xIO::configure() {

/* Change the Prox Sensor Settings 0 */
/* Memory Map Position 0x40 - 0x4B */
  writeRegister( 0x40,  PXS_SETTINGS0_0     );
  writeRegister( 0x41,  PXS_SETTINGS0_1     );
  writeRegister( 0x42,  PXS_SETTINGS0_2     );      
  writeRegister( 0x43,  PXS_SETTINGS0_3     );
  writeRegister( 0x44,  PXS_SETTINGS0_4     );
  writeRegister( 0x45,  PXS_SETTINGS0_5     );
  writeRegister( 0x46,  PXS_SETTINGS0_6     );     
  writeRegister( 0x47,  PXS_SETTINGS0_7     );
  writeRegister( 0x48,  PXS_SETTINGS0_8     );
  writeRegister( 0x49,  PXS_SETTINGS0_9     );     
  writeRegister( 0x4a,  PXS_SETTINGS0_10    );     
  writeRegister( 0x4b,  PXS_SETTINGS0_11    );     

/* Change the Prox Sensor Settings 1 */
/* Memory Map Position 0x50 - 0x57 */
  writeRegister( 0x50,  PXS_SETTINGS1_0  );
  writeRegister( 0x51,  PXS_SETTINGS1_1  );
  writeRegister( 0x52,  PXS_SETTINGS1_2  );
  writeRegister( 0x53,  PXS_SETTINGS1_3  );
  writeRegister( 0x54,  PXS_SETTINGS1_4  );
  writeRegister( 0x55,  PXS_SETTINGS1_5  );
  writeRegister( 0x56,  PXS_SETTINGS1_6  );
  writeRegister( 0x57,  PXS_SETTINGS1_7  );
  
/* Change the Prox UI Settings */
/* Memory Map Position 0x60 - 0x66 */
  writeRegister( 0x60,  PXS_UI_SETTINGS_0    );
  writeRegister( 0x61,  PXS_UI_SETTINGS_1    );
  writeRegister( 0x62,  PXS_UI_SETTINGS_2    );
  writeRegister( 0x63,  PXS_UI_SETTINGS_3    );
  writeRegister( 0x64,  PXS_UI_SETTINGS_4    );
  writeRegister( 0x65,  PXS_UI_SETTINGS_5    );
  writeRegister( 0x66,  PXS_UI_SETTINGS_6    );

/* Change the SAR UI Settings */
/* Memory Map Position 0x70 - 0x75 */
  writeRegister( 0x70,  SAR_UI_SETTINGS_0    );
  writeRegister( 0x71,  SAR_UI_SETTINGS_1    );
  writeRegister( 0x72,  SAR_UI_SETTINGS_2    );
  writeRegister( 0x73,  SAR_UI_SETTINGS_3    );
  writeRegister( 0x74,  SAR_UI_SETTINGS_4    );
  writeRegister( 0x75,  SAR_UI_SETTINGS_5    );
  
/* Change the Metal Detect UI Settings */
/* Memory Map Position 0x80 - 0x83 */
  writeRegister( 0x80,  METAL_DETECT_UI_SETTINGS_0    );
  writeRegister( 0x81,  METAL_DETECT_UI_SETTINGS_1    );
  writeRegister( 0x82,  METAL_DETECT_UI_SETTINGS_2    );
  writeRegister( 0x83,  METAL_DETECT_UI_SETTINGS_3    );

/* Change the HALL Sensor Settings */
/* Memory Map Position 0x90 - 0x93 */
  writeRegister( 0x90,  HALL_SENSOR_SETTINGS_0    );
  writeRegister( 0x91,  HALL_SENSOR_SETTINGS_1    );
  writeRegister( 0x92,  HALL_SENSOR_SETTINGS_2    );
  writeRegister( 0x93,  HALL_SENSOR_SETTINGS_3    );

/* Change the HALL Switch UI Settings */
/* Memory Map Position 0xA0 - 0xA2 */
  writeRegister( 0xa0,  HALL_UI_SETTINGS_0    );
  writeRegister( 0xa1,  HALL_UI_SETTINGS_1    );
  writeRegister( 0xa2,  HALL_UI_SETTINGS_2    );

/* Change the Temperature UI Settings */
/* Memory Map Position 0xC0 - 0xC3 */
  writeRegister( 0xc0,  TEMP_UI_SETTINGS_0    );
  writeRegister( 0xc1,  TEMP_UI_SETTINGS_1    );
  writeRegister( 0xc2,  TEMP_UI_SETTINGS_2    );
  writeRegister( 0xc3,  TEMP_UI_SETTINGS_3    );

/* Change the Device & PMU Settings */
/* Memory Map Position 0xD0 - 0xD8 */
  writeRegister( 0xd0,  SYSTEM_SETTINGS        );
  writeRegister( 0xd1,  ACTIVE_CHS             );            
  writeRegister( 0xd2,  PMU_SETTINGS           );
  writeRegister( 0xd3,  REPORT_RATES_TIMINGS_0 );    
  writeRegister( 0xd4,  REPORT_RATES_TIMINGS_1 );
  writeRegister( 0xd5,  REPORT_RATES_TIMINGS_2 );
  writeRegister( 0xd6,  REPORT_RATES_TIMINGS_3 );
  writeRegister( 0xd7,  GLOBAL_EVENT_MASK      );
  writeRegister( 0xd8,  PWM_DUTY_CYCLE         );

}
// end of IQS620_Init.cpp