// IQS620-HelloWorld.cpp

// Hello World program for Azoteq IQS620 ultra low power sensor for magnetic field, capacitive touch and inductive proximity sensor.

// More info on Azoteq IQS620 page: http://www.azoteq.com/products/proxfusion/iqs620?mbed

// ProxFusion 5-minute YouTube video: https://youtu.be/l7tO2ra5y74

// IQS620 hardware page on mbed: https://developer.mbed.org/components/IQS620/

// IQS620 eval kit page on mbed: https://developer.mbed.org/components/IQS620-EVAL-1/

// Copyright 2017 Azoteq. Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions: The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

// Output is via the USB debug serial port to any VT100-compatible terminal emulator such as Tera Term or Putty. (Set background to white)

// Tested on the following MBED hardware
// Note: When compiling for new hardware, use "Compile All" to rebuild everything
//  1. ST Micro Nucleo-L152RE   Azoteq Adapter Boards: AZP694A02, AZP690A02
//  2. ST Micro Nucleo-F401RE   Azoteq Adapter Boards: AZP694A02, AZP690A02
//  3. ST Micro Nucleo-L476RG   Azoteq Adapter Boards: AZP694A02, AZP690A02
//  4. ST Micro Nucleo-L053R8   Azoteq Adapter Boards: AZP694A02, AZP690A02
//  5. ST Micro Nucleo-F446RE   Azoteq Adapter Boards: AZP694A02, AZP690A02
//  6. ST Micro Disco-F746NG    Azoteq Adapter Boards: AZP694A02, AZP690A02
//  7. Freescale FRDM-KL46Z     Azoteq Adapter Boards: AZP694A02, AZP690A02
//  8. Freescale FRDM-KL25Z     Azoteq Adapter Boards: AZP694A02, AZP690A02
//  9. mbed LPC1768             Azoteq adapter AZP690A02 [SDA,SCL,RDY] wired to LPC1768 [p28,p27,p26]
// 10. mbed LPC11U24            Azoteq adapter AZP690A02 [SDA,SCL,RDY] wired to LPC11U24 [p28,p27,p26]

// These two boards additionally require you to import the USBDevice library: https://developer.mbed.org/users/mbed_official/code/USBDevice/
// 11. Teensy 3.1               Azoteq adapter AZP690A02 [SDA,SCL,RDY] wired to Teensy 3.1 [p18,p19,p2] 
// 12. Teensy 3.2               Azoteq adapter AZP690A02 [SDA,SCL,RDY] wired to Teensy 3.2 [p18,p19,p2] 

// Direct wiring of ST Micro Nucleo boards to AZP690B02 (IQS620-EVAL-1 board)
// [SDA,SCL,RDY] wired to Nucleo [CN10-5,CN10-3,CN10-33], [GND,3.3V] wired to Nucleo [CN11,CN7-16]


#include "mbed.h"
#include "IQS62x.h"
#include "IQS620DisplayTerminal.h"

IQS620Display terminal;   // class to display IQS62x registers on a terminal
IQS62xIO iqs62x;          // class for basic IQS62x reads and writes using I2C

int main() {
    terminal.helloMessage(false); // say hello but don't wait for a keypress
    iqs62x.configure(); // configure the IC contents of IQS62x_Init.h
    char * color = iqs62x.getTable( color_any_register_that_changed_in_the_previous_20_reads ); // show changes in color
    while(1) {
        iqs62x.readIqsRegisters(0,NUMBER_OF_REGISTERS); // read all the registers
        terminal.showStatus(iqs62x.I2Cspeed,iqs62x.I2CErrorCount); // show heading and number of I2C errors
        terminal.showRegisters(iqs62x.registers, color, false); // display registers, color the registers that changed
    }    
}
// end of IQS620_HelloWorld.cpp