// A class library to display Azoteq IQS620 registers on a terminal

// More info on IQS620 sensor IC: http://bit.ly/IQS620-info

// IQS620 1-minute youtube video: N.A.

#include "mbed.h"

#define DISPLAY_BAUD_RATE 115200 /* baud rate of serial terminal */


#if defined(TARGET_TEENSY3_1) || defined (TARGET_TEENSY3_2) || IQS_USE_USBSERIAL
#warning if USBSerial.h can't be found import this library: developer.mbed.org/users/mbed_official/code/USBDevice
// USBSerial.h comes from the library http://developer.mbed.org/users/mbed_official/code/USBDevice which MUST be imported for Teensy
#include "USBSerial.h"
// USBSerial.h comes from the library http://developer.mbed.org/users/mbed_official/code/USBDevice which MUST be imported for Teensy
#endif

#if defined(TARGET_TEENSY3_1) || defined (TARGET_TEENSY3_2) || IQS_USE_USBSERIAL
class IQS620Display : public USBSerial { // use our own USB serial port (requires USB driver to be installed, see Teensy Website)
    public: void baud(int baudRate);
#else
class IQS620Display : public Serial { // use ARM mbed virtual serial port
#endif

  public:
    int frameCounter;
    IQS620Display(); // constructor
    void helloMessage(bool); // show startup message
    void showStatus(int,int); // show headings and I2C Error Count
    void showLine(char * buffer, char * color, int startbyte, int endbyte); // write one line of register data with color highlighting
    void showRegisters(char *,char *,bool); // show IQS62x registers
};