/* =====================================================================
   Copyright © 2016, Avnet (R)

   Contributors:
     * James M Flynn, www.em.avnet.com 
 
   Licensed under the Apache License, Version 2.0 (the "License"); 
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, 
   software distributed under the License is distributed on an 
   "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
   either express or implied. See the License for the specific 
   language governing permissions and limitations under the License.

    @file          WNCInterface.cpp
    @version       1.0
    @date          Sept 2016

======================================================================== */

// Touch to work-around mbed tag.

#include "mbed.h"
#include "WNCInterface.h"
#include "Sms/IOTSMS.h"

#define MBED_PLATFORM
#define CRLF    "\n\r"

MODSERIAL pc(USBTX,USBRX,256,256);

void msg_rcvd( WNCSmsMsg& msg ) {
  pc.printf("msg_rcvd called, msg from: '%s'" CRLF, msg.number.c_str());
  pc.printf("msg_rcvd from: '%s'" CRLF, msg.date.c_str());
  pc.printf("msg_rcvd at '%s'" CRLF, msg.time.c_str());
  pc.printf("msg_rcvd contained '%s'" CRLF, msg.msg.c_str());
  
}
    
int main() {
    int cnt=1;
    char buf[80];
    char nbr[25];
    string dest = "5277";
    WNCInterface wnc;
    WNCSms iotsms;

    pc.baud(115200);    
    pc.printf(CRLF "STARTING WNC SMS Test" CRLF);
    wnc.init(NULL,&pc);  
    
    pc.printf(" WNC Initialized" CRLF); 
    wnc.doDebug(0);                 
    iotsms.init(1,msg_rcvd);
//    iotsms.init();
    pc.printf(" SMS Initialized" CRLF "get my number: ");

    strncpy(nbr, iotsms.getSMSNbr(), 25);
    pc.printf("%s" CRLF, nbr);
    
    while( 1 ) {
      pc.printf("sending SMS #%d to %s", cnt, dest.c_str() );
      sprintf(buf, "SMS #%d", cnt++);
      pc.printf("..GO; ");
      iotsms.send(dest.c_str(), buf);
      pc.printf("waiting..." CRLF);
      Thread::wait(20000);
      }
}

