==HTTPS File Download Example for TLS Client on mbed OS

Using the AT&T Cellular IoT Starter Kit from [[http://cloudconnectkits.org/product/att-cellular-iot-starter-kit|Avnet]]
the this program downloads a file from an HTTPS server (developer.mbed.org) and looks for a specific string 
in that file.

**NOTE**: 
This doc is specific to using the AT&T Cellular IoT Starter Kit which contains a 
[[https://developer.mbed.org/platforms/FRDM-K64F/|FRDM-K64F]] from NXP.  Ensure that the 
[[https://mbed.org/compiler/|mbed online compiler]] has the platform set to FRDM-K64F. 

1. Launch [[https://mbed.org/compiler/|mbed online compiler]] in your browser

2. In a seperate browser Tab, goto the [[https://developer.mbed.org/teams/Avnet/code/BluemixQS/|Avnet BluemixQS]] site and select the 
   **Import into Compiler** button in the upper right portion of the window.

3. With the example program imported into you work-space, you have all the components needed.  Simply execute the **Compile** button.


==Expected execution outcome==

Once the program is compiled and downloaded to the IoT Kit, perform the following steps:

1. Using a terminal program such as Hyperterm or Putty, connect to the Kit (select comm parameters of 115200-N81)

2. Press the `reset` button, then you should see the program start running! When it runs, the output will look similar to:

<<code title=Sample Ouput>>
Starting HTTPS File Download Example for TLS use WNC Data Module

Toggling Wakeup...
Toggling complete.
WNC Module IS initialized (07).
IP Address: 10.63.211.229 

Connecting with developer.mbed.org
Starting the TLS handshake...
TLS connection to developer.mbed.org established
Server certificate:
    cert. version     : 3
    serial number     : 11:21:B8:47:9B:21:6C:B1:C6:AF:BC:5D:0C:19:52:DC:D7:C3
    issuer name       : C=BE, O=GlobalSign nv-sa, CN=GlobalSign Organization Validation CA - SHA256 - G2
    subject name      : C=GB, ST=Cambridgeshire, L=Cambridge, O=ARM Ltd, CN=*.mbed.com
    issued  on        : 2016-03-03 12:26:08
    expires on        : 2017-04-05 10:31:02
    signed using      : RSA with SHA-256
    RSA key size      : 2048 bits
    basic constraints : CA=false
    subject alt name  : *.mbed.com, mbed.org, *.mbed.org, mbed.com
    key usage         : Digital Signature, Key Encipherment
    ext key usage     : TLS Web Server Authentication, TLS Web Client Authentication
Certificate verification passed

HTTPS: Received 439 chars from server
HTTPS: Received 200 OK status ... [OK]
HTTPS: Received 'Hello world!' status ... [OK]
HTTPS: Received message:

HTTP/1.1 200 OK
Server: nginx/1.7.10
Date: Wed, 02 Nov 2016 19:05:55 GMT
Content-Type: text/plain
Content-Length: 14
Connection: keep-alive
Last-Modified: Fri, 27 Jul 2012 13:30:34 GMT
Accept-Ranges: bytes
Cache-Control: max-age=36000
Expires: Thu, 03 Nov 2016 05:05:55 GMT
X-Upstream-L3: 172.17.0.3:80
X-Upstream-L2: developer-sjc-indigo-1-nginx
Strict-Transport-Security: max-age=31536000; includeSubdomains

Hello world!
  >>> DONE  <<<
<</code>>

==Required Configuration changes==
The networking stack in this example uses TLS functionality. On devices where hardware entropy 
is not present, TLS is disabled by default. This example is not suitable for a productg code 
and the configuration setting are for demonstration purposes. 

To learn more about entropy read:
the [TLS Porting guide](https://docs.mbed.com/docs/mbed-os-handbook/en/5.2/advanced/tls_porting/).

==Debugging the TLS connection==
To print out more debug information about the TLS connection, edit the file `main.cpp` and change the definition 
of `DEBUG_LEVEL` (near the top of the file) from 0 to a positive number:

* Level 1 only prints non-zero return codes from SSL functions and information about the full certificate chain 
  being verified.

* Level 2 prints more information about internal state updates.

* Level 3 is intermediate.

* Level 4 (the maximum) includes full binary dumps of the packets.


The TLS connection can fail with an error similar to:

    mbedtls_ssl_write() failed: -0x2700 (-9984): X509 - Certificate verification failed, e.g. CRL, CA or 
    signature check failed
    Failed to fetch /media/uploads/mbed_official/hello.txt from developer.mbed.org:443

This probably means you need to update the contents of the `SSL_CA_PEM` constant (this can happen if you 
modify `HTTPS_SERVER_NAME`, or when `developer.mbed.org` switches to a new CA when updating its certificate).

Another possible reason for this error is a proxy providing a different certificate. Proxies can be used 
in some network configurations or for performing man-in-the-middle attacks. If you choose to ignore this 
error and proceed with the connection anyway, you can change the definition of `UNSAFE` near the top of the 
file from 0 to 1.

**Warning:** this removes all security against a possible active attacker, so use at your own risk or for debugging only!

==License==
This library is released under the Licensed under the Apache License, Version 2.0 (the "License"); you may not use this 
file except in compliance with the License and may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an 
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.


Set up your environment if you have not done so already. For instructions, refer to the [main readme](../README.md).

