//#define MQTT_DEBUG


#include "mbed.h"
#include "MQTTClient.h"
#include "MQTTFormat.h"

#include "MQTTWNCInterface.h"
#include "rtos.h"
#include "k64f.h"
#include "HTS221.h"

I2C i2c(PTC11, PTC10);         //SDA, SCL -- define the I2C pins being used
MODSERIAL pc(USBTX,USBRX,256,256);

#include "hardware.h"
//
// When the Bluemix device is created, the following information is provided:
//
//    Organization ID 9k09br
//    Device Type ATTIOTK
//    Device ID Mz-11027214-7010
//    Authentication Method token
//    Authentication Token SecurityToken99
// Use this information for the following defines:

#define ORG_ID      "k1hdoc"
#define DEVICE_TYPE "Avnet-WNC_card"
#define DEVICE_NAME "IoT-11027214-2016"
#define USERNAME    "use-token-auth"                                    // not required for demo app
#define PASSWORD    "SecurityToken99"                                    // not required for demo app

#define URL         ORG_ID ".messaging.internetofthings.ibmcloud.com"
#define CLIENTSTR   "d:" ORG_ID ":" DEVICE_TYPE ":%s"

#define PORT        1883                           // MQTT broker port number
#define PUBLISH_TOPIC "iot-2/evt/status/fmt/json"              // MQTT topic
#define SUBSCRIBTOPIC "iot-2/cmd/+/fmt/+"


Queue<uint32_t, 6> messageQ;

// LED color control function
void controlLED(color_t led_color) {
    switch(led_color) {
        case red :
            greenLED = blueLED = 1;          
            redLED = 0.7;
            break;
        case green :
            redLED = blueLED = 1;
            greenLED = 0.7;
            break;
        case blue :
            redLED = greenLED = 1;
            blueLED = 0.7;
            break;
        case off :
            redLED = greenLED = blueLED = 1;
            break;
    }
}
    
// Switch 2 interrupt handler
void sw2_ISR(void) {
    messageQ.put((uint32_t*)22);
}

// Switch3 interrupt handler
void sw3_ISR(void) {
    messageQ.put((uint32_t*)33);
}
 
// MQTT message arrived callback function
void messageArrived(MQTT::MessageData& md) {
    MQTT::Message &message = md.message;
    PRINTF("Receiving MQTT message:  %.*s\r\n", message.payloadlen, (char*)message.payload);
    
    if (message.payloadlen == 3) {
        if (strncmp((char*)message.payload, "red", 3) == 0)
            controlLED(red);
        
        else if(strncmp((char*)message.payload, "grn", 3) == 0)
            controlLED(green);
        
        else if(strncmp((char*)message.payload, "blu", 3) == 0)
            controlLED(blue);
        
        else if(strncmp((char*)message.payload, "off", 3) == 0)
            controlLED(off);
    }        
}

int main() {
    int rc, pSW2=0, txSel=0, good = 0;
    Timer tmr;
    char* topic = PUBLISH_TOPIC;
    char clientID[100], buf[100];
    string st, uniqueID;

    HTS221 hts221;

    pc.baud(115200);
    rc = hts221.init();
    if ( rc  ) {
        PRINTF(BLU "HTS221 Detected (0x%02X)\n\r",rc);
        PRINTF("  Temp  is: %0.2f F \r\n  Huumid is: %02d %%\r\n\r\n",
              CTOF(hts221.readTemperature()), hts221.readHumidity()/10);
    }
    else {
        PRINTF(RED "HTS221 NOT DETECTED!\n\r");
    }

    controlLED(green);
    
    // set SW2 and SW3 to generate interrupt on falling edge 
    switch2.fall(&sw2_ISR);
    switch3.fall(&sw3_ISR);

    // initialize ethernet interface
    MQTTwnc ipstack = MQTTwnc();
    
    // get and display client network info
    WNCInterface& eth = ipstack.getEth();
    
    // construct the MQTT client
    MQTT::Client<MQTTwnc, Countdown> client = MQTT::Client<MQTTwnc, Countdown>(ipstack);

    controlLED(blue);
    
    char* hostname = URL;
    int port = PORT;
    st = eth.getMACAddress();
    uniqueID="IoT-";
    uniqueID += st[0];
    uniqueID += st[1];
    uniqueID += st[3];
    uniqueID += st[4];
    uniqueID += st[6];
    uniqueID += st[7];
    uniqueID += st[9];
    uniqueID += st[10];
    uniqueID += "-2016";

    sprintf(clientID, CLIENTSTR, uniqueID.c_str());

    PRINTF("\r\n\r\n");
    PRINTF("      _____\r\n");
    PRINTF("     *     *\r\n");
    PRINTF("    *____   *____             Bluemix IIoT Demo using\r\n");
    PRINTF("   * *===*   *==*             the AT&T IoT Starter Kit\r\n");
    PRINTF("  *___*===*___**  AVNET\r\n");
    PRINTF("       *======*\r\n");
    PRINTF("        *====*\r\n");
    PRINTF("\r\n");
    PRINTF("This demonstration program operates the same as the original \r\n");
    PRINTF("MicroZed IIoT Starter Kit except it only reads from the HTS221 \r\n");
    PRINTF("temp sensor (no 31855 currently present and no generated data).\r\n");
    PRINTF("\r\n");
    PRINTF("Local network info...\r\n");    
    PRINTF("IP address is %s\r\n", eth.getIPAddress());
    PRINTF("MAC address is %s\r\n", eth.getMACAddress());
    PRINTF("Gateway address is %s\r\n", eth.getGateway());
    PRINTF("Your <uniqueID> is: %s\r\n", uniqueID.c_str());
    PRINTF("---------------------------------------------------------------\r\n");

    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;       

    int tries;
    
    while( !good ) {    
        tries=0;
        // connect to TCP socket and check return code
        tmr.start();
        rc = 1;
        while( rc && tries < 3) {
            PRINTF("\r\n\r\n(%d) Attempting TCP connect to %s:%d:  ", tries++, hostname, port);
            rc = ipstack.connect(hostname, port);
            if( rc ) {
                PRINTF("Failed (%d)!\r\n",rc);
                while( tmr.read_ms() < 5000 ) ;
                tmr.reset();
            }
            else {
                PRINTF("Success!\r\n");
                rc = 0;
            }
        }
        if( tries < 3 )
          tries = 0;
        else
          continue;
        
        data.willFlag = 0;  
        data.MQTTVersion = 3;

        data.clientID.cstring = clientID;
        data.username.cstring = USERNAME;
        data.password.cstring = PASSWORD;
        data.keepAliveInterval = 10;
        data.cleansession = 1;
    
        rc = 1;
        tmr.reset(); 
        while( !client.isConnected() && rc && tries < 3) {
            PRINTF("(%d) Attempting MQTT connect to '%s': ", tries++, clientID);
            rc = client.connect(data);
            if( rc ) {
                PRINTF("Failed (%d)!\r\n",rc);
                while( tmr.read_ms() < 5000 );
                tmr.reset();
            }
            else
                PRINTF("Success!\r\n");
        }

        if( tries < 3 )
          tries = 0;
        else
          continue;

        // subscribe to MQTT topic
        tmr.reset();
        rc = 1;
        while( rc && client.isConnected() && tries < 3) {
            PRINTF("(%d) Attempting to subscribing to MQTT topic '%s': ", tries, SUBSCRIBTOPIC);
            rc = client.subscribe(SUBSCRIBTOPIC, MQTT::QOS0, messageArrived);
            if( rc ) {
                PRINTF("Failed (%d)!\r\n", rc);
                while( tmr.read_ms() < 5000 );
                tries++;
                tmr.reset();
            }
            else {
                good=1;
                PRINTF("Subscribe successful!\r\n");
            }
        }
        while (!good);
    }        
    
    MQTT::Message message;
    message.qos = MQTT::QOS0;
    message.retained = false;
    message.dup = false;
    message.payload = (void*)buf;
    
    while(true) {
        osEvent switchEvent = messageQ.get(100);
      
        if( switchEvent.value.v == 22 )  //switch between sending humidity & temp
          txSel = !txSel;
          
        if( switchEvent.value.v == 33)   //user wants to run in Quickstart of Demo mode
          pSW2 = !pSW2;
                    
        memset(buf,0x00,sizeof(buf));
        if( txSel ) {
            rc = hts221.readHumidity();
            sprintf(buf, "{\"d\" : {\"humd\" : \"%2d.%d\" }}", rc/10, rc-((rc/10)*10));
            PRINTF("Publishing MQTT message '%s' ", (char*)message.payload);
            }
        else {
             sprintf(buf, "{\"d\" : {\"temp\" : %5d }}", (int)CTOF(hts221.readTemperature())*10);
             PRINTF("Publishing MQTT message '%s' ", (char*)message.payload);
            }
         message.payloadlen = strlen(buf);
         PRINTF("(%d)\r\n",message.payloadlen);
         rc = client.publish(topic, message);
         if( rc ) {
             PRINTF("Publish request failed! (%d)\r\n",rc);
             FATAL_WNC_ERROR(resume);
             }

        client.yield(6000);
    }           
}
