/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"

#include <iostream>
#include <sstream>
#include "vector"
#include "TextLCD.h"

TextLCD lcd(PA_9, PB_10, PB_4, PB_5, PB_3, PA_10); // rs, rw, e, d0, d1, d2, d3


using namespace std;
DigitalIn incrementbutton(PA_2);
DigitalIn decrementbutton(PA_3);
DigitalIn acceptbutton(PA_10);
DigitalOut myled(PA_0);


struct Attendant {
    char AttendantName[16];
    char systemPassword[5] = "1212";        //password

};
int debug1 = 0;
int main()
{

    std::vector<int > password{};
    char str1[4];

    std::ostringstream oss;

    Attendant Attendant1;

    if (debug1 > 1) {
        std::cout << "Enter Attendant Name"<< std::endl;
        scanf("%s",&Attendant1.AttendantName);
        std::cout << "Welcome " <<  Attendant1.AttendantName << "\nSelect password\n" << std::endl;        //question 1

    }


    int check = 1;
    while(check) {
        lcd.printf("Welcome, Select password");
        wait(1);
        lcd.cls();





        int count;
        for (count = 0; count < 10; count++) {
            if(password.size() < 4) {



                lcd.printf("Select Number : %i",count);
                wait(1);
                lcd.cls();


                if (debug1 > 1) {
                    std::cout << "Select Number : " << count << " ?\n" << std::endl;
                    scanf("%s", &str1);
                }

                if (acceptbutton == 0) {       //RD2 (the button configurations for RD0 will be here)
                    password.push_back(count);
                    //std::cout << password[(password.size() - 1)] << std::endl;
                    count = -1;
                } else if (incrementbutton == 0) {      //incrementing //RD0 (the button configurations for RD1 will be here)
                    continue;
                } else if (decrementbutton == 0) {        //RD1 (the button configurations for RD2 will be here)
                    count--;
                    count--;
                } else {
                    lcd.printf("INValid Selection");
                    wait(1);
                    lcd.cls();

                    if (debug1 > 1) {
                        std::cout << "Enter A Valid Selection\n" << std::endl;
                    }
                }

            }
        }

        std::copy(password.begin(),password.end(),std::ostream_iterator<int>(oss));

        std::string result = oss.str();
        const char *c_result = result.c_str();

        if(!strcmp(c_result,Attendant1.systemPassword)) {
            lcd.printf("%s", c_result);
            lcd.printf("\n");
            wait(1);
            lcd.cls();
             check = 0;
        } else {
            //  std::cout << "password incorrect\n" << "Try Again" << std::endl;

            lcd.printf("incorrect Try Again");
                       wait(1);
                       lcd.cls();
                       password.clear();
        }


    }
    return 0;
};






