#include "mbed.h"
#include "rtos.h"
 
DigitalIn Sw1(PB_0); // Switch1 conectado al pin A3
DigitalIn Sw2(PC_1); // Switch2 conectado al pin A4
DigitalIn Sw3(PC_0); // Switch3 conectado al pin A5
DigitalOut Led1(PB_3); // Led1 conectado al pin D3
DigitalOut Led2(PB_5); // Led2 conectado al pin D4
DigitalOut Led3(PB_4); // Led3 conectado al pin D5
 
void estado1(void const *argument)
{
    while (1) {
        if (!Sw1) {              //verifica el estado del pulsador 
            Led1 = !Sw1;       //cambiar el Led de estado
            Thread::wait(200);  //tiempo de espera 
        }
    }
}
 
void estado2(void const *argument)
{
    while (1) {
        if (!Sw2) {              //verifica el estado del pulsador 
            Led2 = !Sw2;       //cambiar el Led de estado
            Thread::wait(200);  //tiempo de espera 
        }
    }
}
 
void estado3(void const *argument)
{
    while (1) {
        if (!Sw3) {              //verifica el estado del pulsador 
            Led3 = !Sw3;       //cambiar el Led de estado
            Thread::wait(200);  //tiempo de espera 
        }
    }
}
 
 
int main()
{
    Thread thread1(estado1, NULL, osPriorityNormal, DEFAULT_STACK_SIZE);
    Thread thread2(estado2, NULL, osPriorityNormal, DEFAULT_STACK_SIZE);    
    Thread thread3(estado3, NULL, osPriorityNormal, DEFAULT_STACK_SIZE);    
    while (true) {
        Thread::wait(500);
    }
}