#include "mbed.h"
#include <ttmath.h>
#include "PinDetect.h"
#include "uLCD_4DGL.h"

Serial pc(USBTX, USBRX);
Serial esp(p28, p27); // tx, rx
DigitalOut reset(p26);
DigitalOut led1(LED1);
DigitalOut led4(LED4);
Timer t;

uLCD_4DGL uLCD(p9,p10,p11); // serial tx, serial rx, reset pin;
 
PinDetect pb1(p17);
PinDetect pb2(p18);
PinDetect pb3(p19);
PinDetect pb4(p20);

// Global count variable

int volatile hours=12;
int volatile minutes=0;
bool volatile alarmSet=false;
int volatile alarmTimeSet = 0;
int volatile timeDisp=0; //real time
bool volatile AMPM=false; //False AM, true PM

 
int  count,ended,timeout;
char buf[2024];
char snd[1024];
char ssid[32] = "MEwifi";     // enter WiFi router ssid inside the quotes
char pwd [32] = "fxyh5453"; // enter WiFi router password inside the quotes
bool timeReady = false;

char curTime[20];

void SendCMD(),getreply(),ESPconfig(),ESPsetbaudrate(), getTime();
int timeFromResponse();
 void dev_recv()
{
    led1 = !led1;
    while(esp.readable()) {
        pc.putc(esp.getc());
    }
}
 
void pc_recv()
{
    led4 = !led4;
    while(pc.readable()) {
        esp.putc(pc.getc());
    }
}
 
 void pb1_hit_callback (void) {
    count++;
    hours++;
    if(hours>12){ hours= 1; AMPM=!AMPM;}
   
    
    //uLCD.cls();
    //if(AMPM)
    //uLCD.printf("\nAlarm Time %d : %d PM\nTime %d\nAlarm Time %d",hours, minutes, secondsTime, alarmTimeSet);
    //else
    //uLCD.printf("\nAlarm Time %d : %d AM\nTime %d\nAlarm Time %d",hours, minutes, secondsTime, alarmTimeSet);
}

void pb2_hit_callback (void) {
    count++;
    minutes++;
    if(minutes>59) minutes= 0;
    //uLCD.cls();
    //if(AMPM)
    //uLCD.printf("\nAlarm Time %d : %d PM\nTime %d\nAlarm Time %d",hours, minutes, secondsTime, alarmTimeSet);
    //else
    //uLCD.printf("\nAlarm Time %d : %d AM\nTime %d\nAlarm Time %d",hours, minutes, secondsTime, alarmTimeSet);
}

void pb3_hit_callback (void) {
    alarmSet=true;
    alarmTimeSet=60*60*hours+60*minutes;
    if(AMPM) alarmTimeSet += 60*60*12;
    //uLCD.cls();
    //uLCD.printf("\nAlarm Time %d : %d\nTime %d\nAlarm Turned On",hours, minutes, secondsTime);
}

void pb4_hit_callback (void) {
    alarmSet=false;
    //uLCD.cls();
    //uLCD.printf("\nAlarm Time %d : %d\nTime %d\nAlarm Turned Off",hours, minutes, secondsTime);
}
 
int main()
{
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    pb4.mode(PullUp);
   
    wait(.001);
    // Setup Interrupt callback function for a pb hit
    pb1.attach_deasserted(&pb1_hit_callback);
    pb2.attach_deasserted(&pb2_hit_callback);
    pb3.attach_deasserted(&pb3_hit_callback);
    pb4.attach_deasserted(&pb4_hit_callback);
    
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();
    pb3.setSampleFrequency();
    pb4.setSampleFrequency();
    
    reset=0; //hardware reset for 8266
    pc.baud(9600);  // set what you want here depending on your terminal program speed
    pc.printf("\f\n\r-------------ESP8266 Hardware Reset-------------\n\r");
    wait(0.5);
    reset=1;
    timeout=2;
    getreply();
 
    esp.baud(9600);   // change this to the new ESP8266 baudrate if it is changed at any time.
 
    //ESPsetbaudrate();   //******************  include this routine to set a different ESP8266 baudrate  ******************
 
    ESPconfig();        //******************  include Config to set the ESP8266 configuration  ***********************
    getTime();
    pc.printf("%s", buf);
    
    timeDisp = timeFromResponse();
    set_time(timeDisp);
    
    pc.printf("%d", timeDisp);
    timeDisp = timeDisp%86400;
        while (1) {
    time_t secondsTime = time(NULL)%86400;
    uLCD.cls();
    if(AMPM)
    uLCD.printf("\nAlarm Time %d : %d PM\nTime %d\nAlarm Time %d",hours, minutes, secondsTime, alarmTimeSet);
    else
    uLCD.printf("\nAlarm Time %d : %d AM\nTime %d\nAlarm Time %d",hours, minutes, secondsTime, alarmTimeSet);
        //timeDisp++;
        if(alarmSet&&int(alarmTimeSet/60)==int(secondsTime/60)){
            uLCD.cls();
            uLCD.printf("ALARM");
            }
        
        wait(.5);
    }
 
}

// Sets new ESP8266 baurate, change the esp.baud(xxxxx) to match your new setting once this has been executed
void ESPsetbaudrate()
{
    strcpy(snd, "AT+CIOBAUD=115200\r\n");   // change the numeric value to the required baudrate
    SendCMD();
}
 
//  +++++++++++++++++++++++++++++++++ This is for ESP8266 config only, run this once to set up the ESP8266 +++++++++++++++
void ESPconfig()
{

    wait(5);
    pc.printf("\f---------- Starting ESP Config ----------\r\n\n");
        strcpy(snd,".\r\n.\r\n");
    SendCMD();
        wait(1);
    pc.printf("---------- Reset & get Firmware ----------\r\n");
    strcpy(snd,"node.restart()\r\n");
    SendCMD();
    timeout=5;
    getreply();
    pc.printf(buf);
 
    
    // set CWMODE to 1=Station,2=AP,3=BOTH, default mode 1 (Station)
    pc.printf("\n---------- Setting Mode ----------\r\n");
    strcpy(snd, "wifi.setmode(wifi.STATION)\r\n");
    SendCMD();
    timeout=4;
    getreply();
    pc.printf(buf);
 
    wait(1);

    strcpy(snd, "wifi.sta.config(\"");
    strcat(snd, ssid);
    strcat(snd, "\",\"");
    strcat(snd, pwd);
    strcat(snd, "\")\r\n");
    SendCMD();
    timeout=10;
    getreply();
    pc.printf(buf);
 
    wait(1);
 
    pc.printf("\n---------- Get IP's ----------\r\n");
    strcpy(snd, "print(wifi.sta.getip())\r\n");
    SendCMD();
    timeout=3;
    getreply();
    pc.printf(buf);
 
    wait(1);
 
    pc.printf("\n---------- Get Connection Status ----------\r\n");
    strcpy(snd, "print(wifi.sta.status())\r\n");
    SendCMD();
    timeout=5;
    getreply();
    
}
void getTime() {
    wait(1);
    strcpy(snd,"sk=net.createConnection(net.TCP, 0)\r\n");
    SendCMD();
    timeout=3;
    getreply();
    
    strcpy(snd,"sk:on(\"receive\", function(sck, c) print(c) end )\r\n");
    SendCMD();
    timeout=3;
    getreply();
    
    strcpy(snd,"sk:connect(80,\"api.timezonedb.com\")\r\n");
    SendCMD();
    timeout=3;
    getreply();
    wait(1);
    
    strcpy(snd, "sk:send(\"GET /v2/get-time-zone?key=ONL9KGITMG1G&format=json&by=zone&zone=America/New_York HTTP/1.1\\r\\nHost: api.timezonedb.com\\r\\nConnection: keep-alive\\r\\nAccept: */*\\r\\n\\r\\n\")\r\n");
    SendCMD();
    timeout=17;
    getreply();
    
    timeReady = true;
    
}
void SendCMD()
{
    esp.printf("%s", snd);
}
 
void getreply()
{
    memset(buf, '\0', sizeof(buf));
    t.start();
    ended=0;
    count=0;
    while(!ended) {
        if(esp.readable()) {
            buf[count] = esp.getc();
            count++;
        }
        if(t.read() > timeout) {
            ended = 1;
            t.stop();
            t.reset();
        }
    }
}

int timeFromResponse() {
    char * timestamp;
    timestamp = strstr(buf, "\"timestamp\":");
    
    timestamp = timestamp + 12;
    int count = 0;
    
    while(timestamp[count] != ',') {
        count++;
    }
    
    strncpy(curTime, timestamp, count);
    return atoi(curTime);
}   