ds#include "mbed.h"
// Att gora

// Select pins for 
// Kolla hur man gar fran string till binary

InterruptIn event1(p15);
InterruptIn event2(p16);
InterruptIn event3(p17);

/*AnalogIn checksens1(p15);
AnalogIn checksens2(p16);
AnalogIn checksens3(p17);*/

AnalogOut enable1(p18);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

int Hall[3];
int switchStep;
int Frequency=10; //Hz
int check;

void Hall1r() {Hall[0]=1; switchStep=1; wait_ms(100);}
void Hall2r() {Hall[1]=1; switchStep=1; wait_ms(100);}
void Hall3r() {Hall[2]=1; switchStep=1; wait_ms(100);}
void Hall1f() {Hall[0]=0; switchStep=1; wait_ms(100);}
void Hall2f() {Hall[1]=0; switchStep=1; wait_ms(100);}
void Hall3f() {Hall[2]=0; switchStep=1; wait_ms(100);}

void init_PWM()
{
    LPC_SC->PCONP |= 1 << 6; // enable power for PWM1 
    
    int prescaler=1;
    LPC_SC->PCLKSEL0 |= prescaler << 12 ; //PCLK = CCLK = 96MHz
    // Prescalers: 0 cclk/4, 1 cclk/1, 2 cclk/2, 3 cclk/8
       
    LPC_PWM1->TCR = 0x00;             //Timer control reg
    LPC_PWM1->CTCR = 0x00;            //Count control reg
    LPC_PWM1->MCR = 0x00;             //Match control
    LPC_PWM1->CCR = 0x00;             //Capture control 
    LPC_PWM1->PCR = 0x00;             //PWM control reg
    LPC_PWM1->LER = 0x00;             //Load enable reg
    LPC_PWM1->PR = 1 - 1;             //Prescale
    
    LPC_PINCON->PINSEL4 = (1<<0)|(1<<2)|(1<<4)|(1<<6)|(1<<8)|(1<<10); //output to pin 2.0 - 2.5
    LPC_PINCON->PINMODE4 =(2<<0)|(2<<2)|(2<<4)|(2<<6)|(2<<8)|(2<<10); //pull down
    
        
    int Frequency=10; //Hz
    

    int mr0=(96000000/prescaler)/Frequency;
    
    LPC_PWM1->MR0 = mr0;  //set clock cycles for PWM. PWM freq = PCLK/MR0 (?)
    LPC_PWM1->MR1 = 0; // DIP 26
    LPC_PWM1->MR2 = 0; // DIP 25
    LPC_PWM1->MR3 = 0; // DIP 24
    LPC_PWM1->MR4 = 0; // DIP 23  
    LPC_PWM1->MR5 = 0; // DIP 22
    LPC_PWM1->MR6 = 0; // DIP 21
       
    LPC_PWM1->LER = (1 << 0) | (1 << 1) ; //Apply changes
    LPC_PWM1->MCR |= (1 << 1) ; // interrupt on match0.Reset timer on Match0;
    LPC_PWM1->PCR = (1<<9)|(1<<10)|(1<<11)|(1<<12)|(1<<13)|(1<<14); //--- PWM1 output
    LPC_PWM1->TCR = (1<<0)|(1<<3);    
}

void dutyC(int dutyy, int pin) //dutyy is the input dutycycle (0-100), input in "pin" (1-6) which PWM pin that one wants to change.
{   
    if (pin<=6)
    {
    int mr00=(96000000)/Frequency;
     
    LPC_PWM1->TCR = (1<<1)|(1<<0);

    LPC_PWM1->MR0 = 0; 
    LPC_PWM1->TCR = (0<<1); 
    LPC_PWM1->MR0 = mr00; 
   
    if (pin==1){LPC_PWM1->MR1 = mr00*dutyy/100;}
    else if (pin==2){LPC_PWM1->MR2 = mr00*dutyy/100;}
    else if (pin==3){LPC_PWM1->MR3 = mr00*dutyy/100;}
    else if (pin==4){LPC_PWM1->MR4 = mr00*dutyy/100;}
    else if (pin==5){LPC_PWM1->MR5 = mr00*dutyy/100;}
    else if (pin==6){LPC_PWM1->MR6 = mr00*dutyy/100;}
    LPC_PWM1->LER = (1 << 0) | (1 << 1) ; //Apply changes
    LPC_PWM1->TCR = (1<<0)|(1<<3);
    }
    else if (pin==7);
    enable1=dutyy/100;
}

void Sixstepswitch(int En1, int En2, int En3, int Sw1, int Sw2, int Sw3) //En = enable switches //Sw set positive or negative direction (1pos, 0neg)
{  
    dutyC(En1*100,2);   //Enable switch 1
    dutyC(En2*100,3);   //Enable switch 2
    dutyC(En3*100,4);     //Disable switch 3
    dutyC(Sw1*100,5);     //switch 1 negative
    dutyC(Sw2*100,6);   //switch 2 positive
    dutyC(Sw3*100,7);     //Unused
}

int main(void)
{
    event1.rise(&Hall1r); // rise 15
    event2.rise(&Hall2r); // rise 16
    event3.rise(&Hall3r); // rise 17
    
    event1.fall(&Hall1f); // fall 15
    event2.fall(&Hall2f); // fall 16
    event3.fall(&Hall3f); // fall 17
    
    Hall[0]=1;
    Hall[1]=0;
    Hall[2]=1;
    //led1=1;
    //led2=0;
    //led3=1;
    //led4=1;
    
    init_PWM();
    //switchStep=1;
    //dutyC(100,7);
    wait_ms(100);
    led4=0;
    
    check=1;
    switchStep=0;
    //Sixstepswitch(1,1,0,0,1,0);
    
    while(1)
    {   
    //six steps
        if (Hall[0]==1 && Hall[1]==0 && Hall[2]==1 && switchStep==1)// gives Emf1 = -1 1 0
        {      
            Sixstepswitch(1,1,0,0,1,0);  //Sixstepswitch(int En1, int En2, int En3, int Sw1, int Sw2, int Sw3)                   
            switchStep=0;//                              DIP 25   DIP 24   DIP 23   DIP 22   DIP 21   DIP 18
        }
        
        else if ((Hall[0]==1 && Hall[1]==0 && Hall[2]==0 && switchStep==1))// gives Emf2= -1 0 1
        {
            Sixstepswitch(1,0,1,0,0,1);  //Sixstepswitch(int En1, int En2, int En3, int Sw1, int Sw2, int Sw3)   
            switchStep=0;//                              DIP 25   DIP 24   DIP 23   DIP 22   DIP 21   DIP 18
        }
        else if ((Hall[0]==1 && Hall[1]==1 && Hall[2]==0 && switchStep==1))// gives Emf3= 0 -1 1
        {
            Sixstepswitch(0,1,1,0,0,1);  //Sixstepswitch(int En1, int En2, int En3, int Sw1, int Sw2, int Sw3)   
            switchStep=0;//                              DIP 25   DIP 24   DIP 23   DIP 22   DIP 21   DIP 18
        }
        
        else if ((Hall[0]==0 && Hall[1]==1 && Hall[2]==0 && switchStep==1))// gives Emf4= 1 -1 0
        {
            Sixstepswitch(1,1,0,1,0,0);  //Sixstepswitch(int En1, int En2, int En3, int Sw1, int Sw2, int Sw3)       
            switchStep=0;//                              DIP 25   DIP 24   DIP 23   DIP 22   DIP 21   DIP 18    
        }
        
        else if ((Hall[0]==0 && Hall[1]==1 && Hall[2]==1 && switchStep==1))// gives Emf5= 1 0 -1
        {
            Sixstepswitch(1,0,1,1,0,0);  //Sixstepswitch(int En1, int En2, int En3, int Sw1, int Sw2, int Sw3)        
            switchStep=0;//                              DIP 25   DIP 24   DIP 23   DIP 22   DIP 21   DIP 18  
        }
        else if ((Hall[0]==0 && Hall[1]==0 && Hall[2]==1 && switchStep==1))// gives Emf6= 0 1 -1
        {
            Sixstepswitch(0,1,1,0,1,0);  //Sixstepswitch(int En1, int En2, int En3, int Sw1, int Sw2, int Sw3)      
            switchStep=0;//                              DIP 25   DIP 24   DIP 23   DIP 22   DIP 21   DIP 18
        }
        else if (check==1)
        {
    
            if(event1>0.5) {Hall[0]=1;} else {Hall[0]=0;}
            if(event2>0.5) {Hall[1]=1;} else {Hall[1]=0;}
            if(event3>0.5) {Hall[2]=1;} else {Hall[2]=0;}
            switchStep=1;
            check=0;
        }
        
    }
}