#include "mbed.h"
// Att gora

// Select pins for 
// Kolla hur man gar fran string till binary

InterruptIn event1(p15);
InterruptIn event2(p16);
InterruptIn event3(p17);

//Ticker VoltStep;
//InterruptIn stoppHallEvent1(p18);
//InterruptIn stoppHallEvent2(p19);

/*AnalogIn checksens1(p15);
AnalogIn checksens2(p16);
AnalogIn checksens3(p17);*/

//AnalogOut enable1(p18);

int Hall[3];
int switchStep;
int Frequency=100000; //Hz
int check;
int tim=1;
int Voltage[]={50,100,100,100};
int dutyPin;
int dir=1;
int pos=0;
int X=200;
int mr0=(96000000)/Frequency;


void init_PWM()
{
    LPC_SC->PCONP |= 1 << 6; // enable power for PWM1 
    
    int prescaler=1;
    LPC_SC->PCLKSEL0 |= prescaler << 12 ; //PCLK = CCLK = 96MHz
    // Prescalers: 0 cclk/4, 1 cclk/1, 2 cclk/2, 3 cclk/8
       
    LPC_PWM1->TCR = 0x00;             //Timer control reg
    LPC_PWM1->CTCR = 0x00;            //Count control reg
    LPC_PWM1->MCR = 0x00;             //Match control
    LPC_PWM1->CCR = 0x00;             //Capture control 
    LPC_PWM1->PCR = 0x00;             //PWM control reg
    LPC_PWM1->LER = 0x00;             //Load enable reg
    LPC_PWM1->PR = 1 - 1;             //Prescale
    
    LPC_PINCON->PINSEL4 = (1<<0)|(1<<2)|(1<<4)|(1<<6)|(1<<8)|(1<<10); //output to pin 2.0 - 2.5
    LPC_PINCON->PINMODE4 =(2<<0)|(2<<2)|(2<<4)|(2<<6)|(2<<8)|(2<<10); //pull down    
    
    LPC_PWM1->MR0 = mr0;  //set clock cycles for PWM. PWM freq = PCLK/MR0 (?)
    LPC_PWM1->MR1 = 0; // DIP 26
    LPC_PWM1->MR2 = 0; // DIP 25
    LPC_PWM1->MR3 = 0; // DIP 24
    LPC_PWM1->MR4 = 0; // DIP 23  
    LPC_PWM1->MR5 = 0; // DIP 22
    LPC_PWM1->MR6 = 0; // DIP 21
       
    LPC_PWM1->LER = (1 << 0) | (1 << 1) ; //Apply changes
    LPC_PWM1->MCR |= (1 << 1) ; // interrupt on match0.Reset timer on Match0;
    LPC_PWM1->PCR = (1<<9)|(1<<10)|(1<<11)|(1<<12)|(1<<13)|(1<<14); //--- PWM1 output
    LPC_PWM1->TCR = (1<<0)|(1<<3);    
}

void dutyC(int dutyy, int pin) //dutyy is the input dutycycle (0-100), input in "pin" (1-6) which PWM pin that one wants to change.
{ 
    LPC_PWM1->TCR = (1<<1)|(1<<0);

    LPC_PWM1->MR0 = 0; 
    LPC_PWM1->TCR = (0<<1); 
    LPC_PWM1->MR0 = mr0; 
   
    if      (pin==1){LPC_PWM1->MR1 = mr0*dutyy/100;}
    else if (pin==2){LPC_PWM1->MR2 = mr0*dutyy/100;}
    else if (pin==3){LPC_PWM1->MR3 = mr0*dutyy/100;}
    else if (pin==4){LPC_PWM1->MR4 = mr0*dutyy/100;}
    else if (pin==5){LPC_PWM1->MR5 = mr0*dutyy/100;}
    else if (pin==6){LPC_PWM1->MR6 = mr0*dutyy/100;}
    LPC_PWM1->LER = (1 << 0) | (1 << 1) ; //Apply changes
    LPC_PWM1->TCR = (1<<0)|(1<<3);
}

void Sixstepswitch(int En1, int En2, int En3, int Sw1, int Sw2, int Sw3) //En = enable switches //Sw set positive or negative direction (1pos, 0neg)
{  
    static int En1Old;
    static int En2Old;
    static int En3Old;
    static int Sw1Old;
    static int Sw2Old;
    static int Sw3Old;

    if (En1!=X && En1!=En1Old){dutyC(En1,1);}     //Enable switch 1
    if (En2!=X && En2!=En2Old){dutyC(En2,2);}     //Enable switch 2
    if (En3!=X && En3!=En3Old){dutyC(En3,3);}     //Enable switch 3
    if (Sw1!=X && Sw1!=Sw1Old){dutyC(Sw1,4);}     //switch 1    
    if (Sw2!=X && Sw2!=Sw2Old){dutyC(Sw2,5);}     //switch 2
    if (Sw3!=X && Sw3!=Sw3Old){dutyC(Sw3,6);}     //switch 3
    
    En1Old=En1;
    En2Old=En2;
    En3Old=En3;
    Sw1Old=Sw1;
    Sw2Old=Sw2;
    Sw3Old=Sw3;
    
}

void Brake() //Break ruotine
{
    if      (Hall[0]==1 && Hall[1]==0 && Hall[2]==1){Sixstepswitch(100,100,100,0,100,100);}
    else if (Hall[0]==1 && Hall[1]==0 && Hall[2]==0){Sixstepswitch(100,100,100,100,0,100);}
    else if (Hall[0]==1 && Hall[1]==1 && Hall[2]==0){Sixstepswitch(100,100,100,0,100,100);}
    else if (Hall[0]==0 && Hall[1]==1 && Hall[2]==0){Sixstepswitch(100,100,100,100,100,0);}
    else if (Hall[0]==0 && Hall[1]==1 && Hall[2]==1){Sixstepswitch(100,100,100,100,0,100);}
    else if (Hall[0]==0 && Hall[1]==0 && Hall[2]==1){Sixstepswitch(100,100,100,0,100,100);}
}




/*void Vstep() 
{
     dutyC(Voltage[tim],dutyPin);
     tim++;
     if (tim>(sizeof(Voltage)/sizeof(Voltage[0])))
     {
        tim=0;    
     }
     if (pos==48)
     {
        Brake();
        wait(0.1);
        while(1);
        tim=0;
     }
}*/


void Hall1r() {Hall[0]=1; switchStep=1; pos++;}
void Hall2r() {Hall[1]=1; switchStep=1; pos++;}
void Hall3r() {Hall[2]=1; switchStep=1; pos++;}
void Hall1f() {Hall[0]=0; switchStep=1; pos++;}
void Hall2f() {Hall[1]=0; switchStep=1; pos++;}
void Hall3f() {Hall[2]=0; switchStep=1; pos++;}

/*void stopHall1() 
{
    Brake();
    wait(3);
    dir=1;
    check=1;
    pos=0;
    switchStep=0;
}
void stopHall2() 
{
    Brake();
    wait(3);
    dir=-1;
    check=1;
    pos=0;
    switchStep=0;
}*/

int main(void)
{
    event1.rise(&Hall1r); // rise p15
    event2.rise(&Hall2r); // rise p16
    event3.rise(&Hall3r); // rise p17
    
    event1.fall(&Hall1f); // fall p15
    event2.fall(&Hall2f); // fall p16
    event3.fall(&Hall3f); // fall p17
    
   // stoppHallEvent1.fall(&stopHall1); //StoppEvent P18
   // stoppHallEvent2.fall(&stopHall2); //StoppEvent p19
       
    init_PWM();
    
    Hall[0]=1;
    Hall[1]=0;
    Hall[2]=1;

    wait_ms(100);
    
    check=1;
    switchStep=0;
    //Sixstepswitch(1,1,0,0,1,0);
    
    //NVIC_SetPriority(TIMER3_IRQn, 4);       // Timer priority 
    //VoltStep.attach_us(&Vstep, 1000);        // Voltage step interrupt timer and frequency
    
    while(1)
    {   
        //six steps
        if (Hall[0]==1 && Hall[1]==0 && Hall[2]==1 && switchStep==1)// gives Emf1 = -1 1 0
        {     
        
            switchStep=0;//                                     DIP 25   DIP 24   DIP 23   DIP 22   DIP 21   DIP 18
            Sixstepswitch(100,100,0,0,100,X);  //Sixstepswitch(int En1, int En2, int En3, int Sw1, int Sw2, int Sw3)                  
            
            //dutyPin=5;                                  //posdir                       -1        1       0         
        }
        
        else if ((Hall[0]==1 && Hall[1]==0 && Hall[2]==0 && switchStep==1))// gives Emf2= -1 0 1
        {
            switchStep=0;//                                     DIP 25   DIP 24   DIP 23   DIP 22   DIP 21   DIP 18
            Sixstepswitch(100,0,100,0,X,100);  //Sixstepswitch(int En1, int En2, int En3, int Sw1, int Sw2, int Sw3)   
            
            //dutyPin=6;                                  //posdir                       -1        0       1   
        }
        else if ((Hall[0]==1 && Hall[1]==1 && Hall[2]==0 && switchStep==1))// gives Emf3= 0 -1 1
        {
            switchStep=0;//                                     DIP 25   DIP 24   DIP 23   DIP 22   DIP 21   DIP 18
            Sixstepswitch(0,100,100,X,0,100);  //Sixstepswitch(int En1, int En2, int En3, int Sw1, int Sw2, int Sw3)   
            
            //dutyPin=6;                                  //posdir                       0        -1       1   
        }
        
        else if ((Hall[0]==0 && Hall[1]==1 && Hall[2]==0 && switchStep==1))// gives Emf4= 1 -1 0
        {
            switchStep=0;//                                     DIP 25   DIP 24   DIP 23   DIP 22   DIP 21   DIP 18  
            Sixstepswitch(100,100,0,100,0,X);  //Sixstepswitch(int En1, int En2, int En3, int Sw1, int Sw2, int Sw3)       
            //dutyPin=4;                                  //posdir                       1        -1       0    
        }
        
        else if ((Hall[0]==0 && Hall[1]==1 && Hall[2]==1 && switchStep==1))// gives Emf5= 1 0 -1
        {
            switchStep=0;//                                     DIP 25   DIP 24   DIP 23   DIP 22   DIP 21   DIP 18 
            Sixstepswitch(100,0,100,100,X,0);  //Sixstepswitch(int En1, int En2, int En3, int Sw1, int Sw2, int Sw3)        
            //dutyPin=4;                                  //posdir                       1        0       -1    
        }
        else if ((Hall[0]==0 && Hall[1]==0 && Hall[2]==1 && switchStep==1))// gives Emf6= 0 1 -1
        {
            switchStep=0;//                                     DIP 25   DIP 24   DIP 23   DIP 22   DIP 21   DIP 18
            Sixstepswitch(0,100,100,X,100,0);  //Sixstepswitch(int En1, int En2, int En3, int Sw1, int Sw2, int Sw3)      
            //dutyPin=5;                                  //posdir                       0        1       -1   
        }
        else if (check==1)//Init state
        {
    
            if(event1>0.5) {Hall[0]=1;} else {Hall[0]=0;}
            if(event2>0.5) {Hall[1]=1;} else {Hall[1]=0;}
            if(event3>0.5) {Hall[2]=1;} else {Hall[2]=0;}
            switchStep=1;
            check=0;
        }
        
    }
}